

Func _WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
	Local $structNMHDR = DllStructCreate("hwnd hWndFrom;int IDFrom;int Code", $ilParam) ; tagNMHDR
	;Local $hwndFrom = DllStructGetData($structNMHDR, 'hWndFrom')
	;Local $ControlHandle = BitAND($iwParam, 0x0000FFFF) ;Control Handle (if needed)
	Local $sClassName = DllCall("User32.dll", "int", "GetClassName", "hwnd", DllStructGetData($structNMHDR, 1), "str", "", "int", 512)
	If IsArray($sClassName) Then $sClassName = $sClassName[2]


	IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) then _Write_ISN_Debug_Console("WM_NOTIFY evnt class:" & $sClassName & " hWnd:" & $hWnd & " iMsg:" & $iMsg & " iwParam:" & $iwParam & " ilParam:" & $ilParam, $ISN_Debug_Console_Errorlevel_Info)

	;NOTIFYs for TriState Checkboxes UDF, ISN treeviews and finally the TVExplorer UDF
	If StringInStr($sClassName, "treeview") Then
		_ISN_WM_NOTIFY_Treeviews($hWnd, $iMsg, $iwParam, $ilParam)
		$Result = _ISN_WM_NOTIFY_TVExplorer($hWnd, $iMsg, $iwParam, $ilParam)
		If $Result <> $GUI_RUNDEFMSG And $Result <> "" Then
			IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) then _Write_ISN_Debug_Console("WM_NOTIFY treeview part stopped with " & $Result, $ISN_Debug_Console_Errorlevel_Info)
			Return $Result
		EndIf
	EndIf

	;NOTIFYs for the scintilla contols
	If $sClassName = "Scintilla" Then
		$Result = _WM_NOTIFY_EDITOR($hWnd, $iMsg, $iwParam, $ilParam)
		If $Result <> $GUI_RUNDEFMSG And $Result <> "" Then
			IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) then _Write_ISN_Debug_Console("WM_NOTIFY scintilla part stopped with " & $Result, $ISN_Debug_Console_Errorlevel_Info)
			Return $Result
		Endif
	EndIf

	;NOTIFYs for Tab controls
	If StringInStr($sClassName, "tabcontrol") Then
		$Result = _ISN_WM_NOTIFY_Tabs($hWnd, $iMsg, $iwParam, $ilParam)
		If $Result <> $GUI_RUNDEFMSG And $Result <> "" Then
			IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) then _Write_ISN_Debug_Console("WM_NOTIFY tab part stopped with " & $Result, $ISN_Debug_Console_Errorlevel_Info)
			Return $Result
		EndIf
	EndIf

	;NOTIFYs for Listviews and some hotkeys
	If StringInStr($sClassName, "listview") Or StringInStr($sClassName, "listbox") Then
		$Result = _ISN_WM_NOTIFY_Listviews($hWnd, $iMsg, $iwParam, $ilParam)
		If $Result <> $GUI_RUNDEFMSG And $Result <> "" Then
			IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) then _Write_ISN_Debug_Console("WM_NOTIFY listview part stopped with " & $Result, $ISN_Debug_Console_Errorlevel_Info)
			Return $Result
		EndIf
	EndIf

	;NOTIFYs for RichEdits (Debug Console)
	If StringInStr($sClassName, "richedit") Then
		$Result = _ISN_WM_NOTIFY_RichEdits($hWnd, $iMsg, $iwParam, $ilParam)
		If $Result <> $GUI_RUNDEFMSG And $Result <> "" Then
			IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) then _Write_ISN_Debug_Console("WM_NOTIFY richedit part stopped with " & $Result, $ISN_Debug_Console_Errorlevel_Info)
			Return $Result
		EndIf
	EndIf

	;NOTIFYs for the Toolbar
	If StringInStr($sClassName, "toolbar") Or StringInStr($sClassName, "header") Then
		$Result = _ISN_WM_NOTIFY_Toolbar($hWnd, $iMsg, $iwParam, $ilParam)
		If $Result <> $GUI_RUNDEFMSG And $Result <> "" Then
			IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) then _Write_ISN_Debug_Console("WM_NOTIFY toolbar part stopped with " & $Result, $ISN_Debug_Console_Errorlevel_Info)
			Return $Result
		EndIf
	EndIf

	;NOTIFYs for Tooltips (on the toolbar)
	If StringInStr($sClassName, "toolbar") Or StringInStr($sClassName, "tooltips")  Then
		$Result = _ISN_WM_NOTIFY_Tooltips($hWnd, $iMsg, $iwParam, $ilParam)
		If $Result <> $GUI_RUNDEFMSG And $Result <> "" Then
			IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) then _Write_ISN_Debug_Console("WM_NOTIFY toolbar part stopped with " & $Result, $ISN_Debug_Console_Errorlevel_Info)
			Return $Result
		EndIf
	EndIf

	Return $GUI_RUNDEFMSG
EndFunc   ;==>_WM_NOTIFY




Func _ISN_WM_NOTIFY_Treeviews($hWnd, $nMsg, $wParam, $lParam)
	Local $stNmhdr = DllStructCreate("dword;int;int", $lParam)
	Local $hWndFrom = DllStructGetData($stNmhdr, 1)
	Local $nNotifyCode = DllStructGetData($stNmhdr, 3)
	Local $hItem = 0
	Local $tNMHDR = DllStructCreate($tagNMHDR, $lParam)
	Local $hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	Local $iCode = DllStructGetData($tNMHDR, "Code")
	Local $nID = BitAND($wParam, 0x0000FFFF)

	;############## ISN Stuff ##############
	Switch $iCode

		Case $TVN_SELCHANGEDA, $TVN_SELCHANGEDW
			If $nID = $config_selectorlist Then _select_settingscategory()
			If $nID = $projekteinstellungen_navigation Then _Projekteinstellungen_Navigation_Event()
			If $nID = $ISN_VariablesSelector_Listview Then _ISN_VariablesSelector_SelectItem()


		Case $TVN_ENDLABELEDITA, $TVN_ENDLABELEDITW
			If $nID = $hTreeView Or $nID = $ISN_UDF_Manager_GUI_Treeview Then _ISN_TreeViewRename_EndEdit()

	EndSwitch



	;############## TriState UDF Stuff ##############

	; Check if its treeview and only NM_CLICK and TVN_KEYDOWN
	If Not BitAND(GetWindowLong($hWndFrom, $GWL_STYLE), $TVS_CHECKBOXES) Or _
			Not ($nNotifyCode = $NM_CLICK Or $nNotifyCode = $TVN_KEYDOWN) Then Return $GUI_RUNDEFMSG

	If $nNotifyCode = $TVN_KEYDOWN Then
		Local $lpNMTVKEYDOWN = DllStructCreate("dword;int;int;short;uint", $lParam)

		; Check for 'SPACE'-press
		If DllStructGetData($lpNMTVKEYDOWN, 4) <> $VK_SPACE Then Return $GUI_RUNDEFMSG
		$hItem = SendMessage_Tree($hWndFrom, $TVM_GETNEXTITEM, $TVGN_CARET, 0)
	Else
		Local $Point = DllStructCreate("int;int")
;~ 		ControlFocus ( $hWndFrom, "", $hwndFrom )
		GetCursorPos_Tree($Point)
		ScreenToClient($hWndFrom, $Point)

		; Check if clicked on state icon
		Local $tvHit = DllStructCreate("int[2];uint;dword")
		DllStructSetData($tvHit, 1, DllStructGetData($Point, 1), 1)
		DllStructSetData($tvHit, 1, DllStructGetData($Point, 2), 2)

		$hItem = SendMessage_Tree($hWndFrom, $TVM_HITTEST, 0, DllStructGetPtr($tvHit))

		If Not BitAND(DllStructGetData($tvHit, 2), $TVHT_ONITEMSTATEICON) Then Return $GUI_RUNDEFMSG
	EndIf

	If $hItem > 0 Then
		Local $nState = GetItemState($hWndFrom, $hItem)

		$bCheckItems = 1

		If $nState = 1 Then
			$nState = 1
		ElseIf $nState = 2 Then
			$nState = 0
		ElseIf $nState = 3 Then
			$nState = 1
		ElseIf $nState > 3 Then
			$nState = $nState - 1
			$bCheckItems = 0
		EndIf

		SetItemState($hWndFrom, $hItem, $nState)

		$nState += 1

		; If item are disabled there is no chance to change it and it's parents/children
		If $bCheckItems Then
			CheckChildItems($hWndFrom, $hItem, $nState)
			CheckParents($hWndFrom, $hItem, $nState)
		EndIf
	EndIf

EndFunc   ;==>_ISN_WM_NOTIFY_Treeviews


Func _ISN_WM_NOTIFY_Tabs($hWnd, $iMsg, $iwParam, $ilParam)
	Local $hWndtabView, $tNMHDR, $hWndFrom, $iCode
	If Not IsHWnd($hWndtabView) Then $hWndtabView = GUICtrlGetHandle($hWndtabView)
	$tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iCode = DllStructGetData($tNMHDR, "Code")
	Switch $hWndFrom

		Case $quickview_tab_dummy
			Switch $iCode
				Case $NM_CLICK
					_QuickView_Tab_Event()
			EndSwitch


		Case GUICtrlGetHandle($htab)
			Switch $iCode
				Case $NM_RCLICK

					Local $tPOINT = _WinAPI_GetMousePos(True, $hWndFrom)
					Local $iX = DllStructGetData($tPOINT, "X")
					Local $iY = DllStructGetData($tPOINT, "Y")
					Local $hItem = _GUICtrlTab_HitTest($hWndFrom, $iX, $iY)
					If $hItem <> 0 Then
						If $hItem[0] <> _GUICtrlTab_GetCurFocus($htab) Then
							_GUICtrlTab_ActivateTabX($htab, $hItem[0])
							_Show_Tab($hItem[0])
						EndIf
					EndIf

			EndSwitch
	EndSwitch
EndFunc   ;==>_ISN_WM_NOTIFY_Tabs

Func _ISN_WM_NOTIFY_Toolbar($hWnd, $iMsg, $iwParam, $ilParam)
	$tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	$hWndFrom = DllStructGetData($tNMHDR, "hWndFrom")
	$IdFrom = DllStructGetData($tNMHDR, "IDFrom")
	$code = DllStructGetData($tNMHDR, "Code")

	Switch $hWndFrom
		Case $hToolbar
			Switch $code
				Case $TBN_DROPDOWN

					$hMenu = _GUICtrlMenu_CreatePopup()
					Switch $iItem
						Case $ISN_Toolbar_NewFile
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(154), $ISN_Toolbar_NewFile_NewAu3File)
							_GUICtrlMenu_SetItemBmp($hMenu, 0, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 1788, 16, 16))
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(1094) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Create_Temp_Au3_Script), $ISN_Toolbar_NewFile_NewTempAu3File)
							_GUICtrlMenu_SetItemBmp($hMenu, 1, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 1788, 16, 16))
							If $Studiomodus = 1 Then
								_GUICtrlMenu_SetItemGrayed($hMenu, 1, False)
							Else
								_GUICtrlMenu_SetItemGrayed($hMenu, 1, True)
							EndIf
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(1452), $ISN_Toolbar_NewFile_NewAu3udfFile)
							_GUICtrlMenu_SetItemBmp($hMenu, 2, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 1788, 16, 16))
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(153), $ISN_Toolbar_NewFile_NewIsfFile)
							_GUICtrlMenu_SetItemBmp($hMenu, 3, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 780, 16, 16))
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(155), $ISN_Toolbar_NewFile_NewIniFile)
							_GUICtrlMenu_SetItemBmp($hMenu, 4, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 1176, 16, 16))
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(156), $ISN_Toolbar_NewFile_NewTxtFile)
							_GUICtrlMenu_SetItemBmp($hMenu, 5, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 1177, 16, 16))

						Case $ISN_Toolbar_Testproject
							If $Studiomodus = 1 Then
								_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(50) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Testprojekt), $ISN_Toolbar_TestProject_StartMainfile)
								_GUICtrlMenu_SetItemGrayed($hMenu, 0, False)
							Else
								_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(668) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Testprojekt), $ISN_Toolbar_TestProject_StartMainfile)
								_GUICtrlMenu_SetItemGrayed($hMenu, 0, True)
								If Not _GUICtrlTab_GetItemCount($htab) = 0 Then
									Local $GUICtrlTab_GetCurFocus = _GUICtrlTab_GetCurFocus($htab)
									If $GUICtrlTab_GetCurFocus <> -1 Then
										If StringTrimLeft($Datei_pfad[$GUICtrlTab_GetCurFocus], StringInStr($Datei_pfad[$GUICtrlTab_GetCurFocus], ".", 0, -1)) = $Autoitextension Then
											_GUICtrlMenu_SetItemGrayed($hMenu, 0, False)
										EndIf
									EndIf
								EndIf
							EndIf
							_GUICtrlMenu_SetItemBmp($hMenu, 0, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 220, 16, 16))
;~ 							_GUICtrlMenu_SetItemBmp($hMenu, 0, _WinAPI_Create32BitHBITMAP(_WinAPI_ShellExtractIcon($smallIconsdll, 220, 16, 16), 1, 1))
							If $Studiomodus = 1 Then
								_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(488) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Testprojekt_ohne_Parameter), $ISN_Toolbar_TestProject_StartWithoutParameters)
								_GUICtrlMenu_SetItemGrayed($hMenu, 1, False)
							Else
								_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(669) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Testprojekt_ohne_Parameter), $ISN_Toolbar_TestProject_StartWithoutParameters)
								_GUICtrlMenu_SetItemGrayed($hMenu, 1, True)
								Local $GUICtrlTab_GetCurFocus = _GUICtrlTab_GetCurFocus($htab)
								If _GUICtrlTab_GetItemCount($htab) <> 0 And $GUICtrlTab_GetCurFocus <> -1 Then
									If StringTrimLeft($Datei_pfad[$GUICtrlTab_GetCurFocus], StringInStr($Datei_pfad[$GUICtrlTab_GetCurFocus], ".", 0, -1)) = $Autoitextension Then
										_GUICtrlMenu_SetItemGrayed($hMenu, 1, False)
									EndIf
								EndIf
							EndIf
							_GUICtrlMenu_SetItemBmp($hMenu, 1, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 220, 16, 16))
;~ 							_GUICtrlMenu_SetItemBmp($hMenu, 1, _WinAPI_Create32BitHBITMAP(_WinAPI_ShellExtractIcon($smallIconsdll, 220, 16, 16), 1, 1))
							_GUICtrlMenu_AddMenuItem($hMenu, "")
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(1476), $ISN_Toolbar_TestProject_QuickChangeAutoItArchitecture)
							_GUICtrlMenu_SetItemBmp($hMenu, 3, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 1234, 16, 16))
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(490), $ISN_Toolbar_TestProject_SetupStartParameters)
							_GUICtrlMenu_SetItemBmp($hMenu, 4, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 1376, 16, 16))
;~ 							_GUICtrlMenu_SetItemBmp($hMenu, 3, _WinAPI_Create32BitHBITMAP(_WinAPI_ShellExtractIcon($smallIconsdll, 1376, 16, 16), 1, 1))

						Case $ISN_Toolbar_Compile
							$str = ""
							If $Studiomodus = 1 Then
								$str = _Get_langstr(52)
							Else
								$str = _Get_langstr(601)
							EndIf
							_GUICtrlMenu_AddMenuItem($hMenu, $str & @TAB & _Keycode_zu_Text($Hotkey_Keycode_compile), $ISN_Toolbar_Compile_CompileProject)
							_GUICtrlMenu_SetItemBmp($hMenu, 0, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 527, 16, 16))
							_GUICtrlMenu_SetItemGrayed($hMenu, 0, True)
;~ 							_GUICtrlMenu_SetItemBmp($hMenu, 0, _WinAPI_Create32BitHBITMAP(_WinAPI_ShellExtractIcon($smallIconsdll, 527, 16, 16), 1, 1))
							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(1063), $ISN_Toolbar_Compile_ChooseFilesToCompile)
							_GUICtrlMenu_SetItemBmp($hMenu, 1, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 529, 16, 16))
							_GUICtrlMenu_SetItemGrayed($hMenu, 1, True)

							_GUICtrlMenu_AddMenuItem($hMenu, _Get_langstr(563) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_compile_Settings), $ISN_Toolbar_Compile_CompileSettings)
							_GUICtrlMenu_SetItemBmp($hMenu, 2, _CreateBitmapFromIcon(_WinAPI_GetSysColor(4), $smallIconsdll, 529, 16, 16))
							_GUICtrlMenu_SetItemGrayed($hMenu, 2, True)
;~ 							_GUICtrlMenu_SetItemBmp($hMenu, 1, _WinAPI_Create32BitHBITMAP(_WinAPI_ShellExtractIcon($smallIconsdll, 529, 16, 16), 1, 1))
							If $Studiomodus = 1 Then
								_GUICtrlMenu_SetItemGrayed($hMenu, 0, False)
								_GUICtrlMenu_SetItemGrayed($hMenu, 1, False)
								_GUICtrlMenu_SetItemGrayed($hMenu, 2, False)
							EndIf
							If $Studiomodus = 2 And _GUICtrlTab_GetItemCount($htab) <> 0 Then
								Local $GUICtrlTab_GetCurFocus = _GUICtrlTab_GetCurFocus($htab)
								If $GUICtrlTab_GetCurFocus <> -1 Then
									If StringTrimLeft($Datei_pfad[$GUICtrlTab_GetCurFocus], StringInStr($Datei_pfad[$GUICtrlTab_GetCurFocus], ".", 0, -1)) = $Autoitextension Then
										_GUICtrlMenu_SetItemGrayed($hMenu, 0, False)
										_GUICtrlMenu_SetItemGrayed($hMenu, 1, True)
										_GUICtrlMenu_SetItemGrayed($hMenu, 2, False)
									EndIf
								EndIf
							EndIf

					EndSwitch
					$aRet = _GetToolbarButtonScreenPos($Studiofenster, $hToolbar, $iItem, 2)
					If Not IsArray($aRet) Then
						Dim $aRet[2] = [-1, -1]
					EndIf

					; send button dropdown menu item commandID to dummy control for use in GuiGetMsg() or GUICtrlSetOnEvent()
					; allows quick return from message handler : See warning for GUIRegisterMsg() in helpfile
					$iMenuID = _GUICtrlMenu_TrackPopupMenu($hMenu, $hToolbar, $aRet[0], $aRet[1], 1, 1, 2)
					If $iMenuID = $ISN_Toolbar_NewFile_NewAu3File Then _ISN_ShowNewFileGUI(_Get_langstr(154))
					If $iMenuID = $ISN_Toolbar_NewFile_NewAu3udfFile Then _ISN_ShowNewFileGUI(_Get_langstr(1452))
					If $iMenuID = $ISN_Toolbar_NewFile_NewTempAu3File Then _erstelle_neues_temporaeres_skript()
					If $iMenuID = $ISN_Toolbar_NewFile_NewIsfFile Then _ISN_ShowNewFileGUI(_Get_langstr(153))
					If $iMenuID = $ISN_Toolbar_NewFile_NewIniFile Then _ISN_ShowNewFileGUI(_Get_langstr(155))
					If $iMenuID = $ISN_Toolbar_NewFile_NewTxtFile Then _ISN_ShowNewFileGUI(_Get_langstr(156))
					If $iMenuID = $ISN_Toolbar_TestProject_StartMainfile Then _ISN_Projekt_Testen()
					If $iMenuID = $ISN_Toolbar_TestProject_StartWithoutParameters Then _ISN_Projekt_Testen_ohne_Parameter()
					If $iMenuID = $ISN_Toolbar_TestProject_SetupStartParameters Then _Show_Parameterconfig()
					If $iMenuID = $ISN_Toolbar_TestProject_QuickChangeAutoItArchitecture Then _ISN_ShowQuickChangeAutoItArchitectureGUI()
					If $iMenuID = $ISN_Toolbar_Compile_CompileProject Then _Start_Compiling()
					If $iMenuID = $ISN_Toolbar_Compile_CompileSettings Then _Show_Compile()
					If $iMenuID = $ISN_Toolbar_Compile_ChooseFilesToCompile Then _Weitere_Dateien_zum_Kompilieren_waehlen()
					_GUICtrlMenu_DestroyMenu($hMenu)
					;If $iMenuID Then Return $TBDDRET_TREATPRESSED
					Return $TBDDRET_DEFAULT

				Case $TBN_HOTITEMCHANGE
					$tNMTBHOTITEM = DllStructCreate($tagNMTBHOTITEM, $ilParam)
					$i_idOld = DllStructGetData($tNMTBHOTITEM, "idOld")
					$i_idNew = DllStructGetData($tNMTBHOTITEM, "idNew")
					$iItem = $i_idNew
					$dwFlags = DllStructGetData($tNMTBHOTITEM, "dwFlags")

			EndSwitch
	EndSwitch
EndFunc   ;==>_ISN_WM_NOTIFY_Toolbar

Func _ISN_WM_NOTIFY_RichEdits($hWnd, $iMsg, $iwParam, $ilParam)
	$tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iCode = DllStructGetData($tNMHDR, "Code")
	Switch $hWndFrom
		Case $console_chatbox
			Select
				Case $iCode = $EN_MSGFILTER
					$tMsgFilter = DllStructCreate($tagMSGFILTER, $ilParam)
					If DllStructGetData($tMsgFilter, "msg") = $WM_LBUTTONDOWN Then
						If GUICtrlRead($debug_console_selecttextmode_checkbox) = $GUI_UNCHECKED Then GUICtrlSetState($console_commandinput, $GUI_FOCUS)
					EndIf
			EndSelect
	EndSwitch
EndFunc   ;==>_ISN_WM_NOTIFY_RichEdits



Func _ISN_WM_NOTIFY_Tooltips($hWnd, $iMsg, $iwParam, $ilParam)
	Local $tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	Local $hWndFrom = DllStructGetData($tNMHDR, "hWndFrom")
	Local $IdFrom = DllStructGetData($tNMHDR, "IDFrom")
	Local $tInfo = DllStructCreate($tagNMTTDISPINFO, $ilParam)
	Local $iCode = DllStructGetData($tInfo, "Code")


	;Tooltips for tab Tabitems
	Switch $iCode

		Case $TTN_GETDISPINFOW, $TTN_GETDISPINFO ;Tooltips for Tabitems
			Local $tagNMTTDISPINFOW = "hwnd hWndFrom;int IDFrom;int Code;ptr lpszText;wchar szText[80];hwnd hinst;uint uFlags;"
			Local $NMHDR = DllStructCreate($tagNMTTDISPINFOW, $ilParam)
			Local $IdFrom2 = DllStructGetData($NMHDR, 2)
			Local $g_tStruct = DllStructCreate($tagPOINT)
			DllStructSetData($g_tStruct, "x", MouseGetPos(0))
			DllStructSetData($g_tStruct, "y", MouseGetPos(1))
			$FromPoint_control = _WinAPI_WindowFromPoint($g_tStruct)
			Switch $FromPoint_control

				Case GUICtrlGetHandle($htab)
					If $IdFrom2 >= 0 And $IdFrom2 <= 29 Then
						Local $tooltip_text = $Datei_pfad[$IdFrom2]
						_GUIToolTip_UpdateTipText($hToolTip_StudioFenster, 0, GUICtrlGetHandle($htab), $tooltip_text)
					EndIf

				Case $quickview_tab_dummy
					If $QuickView_NoTextinTabs = "true" Then
						_GUIToolTip_UpdateTipText($hToolTip_QuickView_GUI, 0, $quickview_tab_dummy, _QuickView_Get_TabTextfromIndex($IdFrom2))
					Else
						_GUIToolTip_UpdateTipText($hToolTip_QuickView_GUI, 0, $quickview_tab_dummy, "")
					EndIf

			EndSwitch
	EndSwitch



	;Native Tooltips für Toolbar OHNE SKIN!
	If $iCode = $TTN_GETDISPINFOW Then
		$iID = DllStructGetData($tInfo, "IDFrom")
		Switch $iID
			Case $ISN_Toolbar_NewFile ;new file
				DllStructSetData($tInfo, "aText", _Get_langstr(43))
			Case $ISN_Toolbar_NewFolder ;new folder
				DllStructSetData($tInfo, "aText", _Get_langstr(46))
			Case $ISN_Toolbar_ImportFiles ;import
				DllStructSetData($tInfo, "aText", _Get_langstr(44))
			Case $ISN_Toolbar_ExportFile ;export
				DllStructSetData($tInfo, "aText", _Get_langstr(49))
			Case $ISN_Toolbar_DeleteFile ;löschen
				DllStructSetData($tInfo, "aText", _Get_langstr(45))
			Case $ISN_Toolbar_RefreshProjecttree ;projecttree
				DllStructSetData($tInfo, "aText", _Get_langstr(53))
			Case $ISN_Toolbar_Testproject ;testproject
				DllStructSetData($tInfo, "aText", _Get_langstr(50))
			Case $ISN_Toolbar_Compile ;Projekt kompilieren
				DllStructSetData($tInfo, "aText", _Get_langstr(52))
			Case $ISN_Toolbar_ProjectProperties ;Projekt Eigenschaften
				DllStructSetData($tInfo, "aText", _Get_langstr(51))
			Case $ISN_Toolbar_Save ;speichern
				DllStructSetData($tInfo, "aText", _Get_langstr(54))
			Case $ISN_Toolbar_Undo ;undo
				DllStructSetData($tInfo, "aText", _Get_langstr(55))
			Case $ISN_Toolbar_Redo ;redo
				DllStructSetData($tInfo, "aText", _Get_langstr(56))
			Case $ISN_Toolbar_CloseTab ;closetab
				DllStructSetData($tInfo, "aText", _Get_langstr(80))
			Case $ISN_Toolbar_TestScript ;testscript
				DllStructSetData($tInfo, "aText", _Get_langstr(82))
			Case $ISN_Toolbar_StopScript ;stopscript
				DllStructSetData($tInfo, "aText", _Get_langstr(106))
			Case $ISN_Toolbar_ToggleSearch ;search
				DllStructSetData($tInfo, "aText", _Get_langstr(85))
			Case $ISN_Toolbar_Au3SyntaxCheck ;syntaxcheck
				DllStructSetData($tInfo, "aText", _Get_langstr(108))
			Case $ISN_Toolbar_TidySource ;tidy
				DllStructSetData($tInfo, "aText", _Get_langstr(327))
			Case $ISN_Toolbar_ImportFolder ;import folder
				DllStructSetData($tInfo, "aText", _Get_langstr(455))
			Case $ISN_Toolbar_ToggleFullscreen ;fullscreenmode
				DllStructSetData($tInfo, "aText", _Get_langstr(457))
			Case $ISN_Toolbar_Macros ;macros
				DllStructSetData($tInfo, "aText", _Get_langstr(519))
			Case $ISN_Toolbar_CommentOut ;comment out
				DllStructSetData($tInfo, "aText", _Get_langstr(328))
			Case $ISN_Toolbar_WindowInfoTool ;window info tool
				DllStructSetData($tInfo, "aText", _Get_langstr(609))
			Case $ISN_Toolbar_MacroSlot1 ;macro 1
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(1))
			Case $ISN_Toolbar_MacroSlot2 ;macro 2
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(2))
			Case $ISN_Toolbar_MacroSlot3 ;macro 3
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(3))
			Case $ISN_Toolbar_MacroSlot4 ;macro 4
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(4))
			Case $ISN_Toolbar_MacroSlot5 ;macro 5
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(5))
			Case $ISN_Toolbar_MacroSlot6 ;macro 6
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(6))
			Case $ISN_Toolbar_MacroSlot7 ;macro 7
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(7))
			Case $ISN_Toolbar_MacroSlot8 ;macro 8
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(8))
			Case $ISN_Toolbar_MacroSlot9 ;macro 9
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(9))
			Case $ISN_Toolbar_MacroSlot10 ;macro 10
				DllStructSetData($tInfo, "aText", _Macroslot_get_name(10))
			Case $ISN_Toolbar_SaveAllTabs ;save all tabs
				DllStructSetData($tInfo, "aText", _Get_langstr(649))
			Case $ISN_Toolbar_ChangelogManager
				DllStructSetData($tInfo, "aText", _Get_langstr(911))
			Case $ISN_Toolbar_ISNSettings
				DllStructSetData($tInfo, "aText", _Get_langstr(42))
			Case $ISN_Toolbar_ProjectSettings
				DllStructSetData($tInfo, "aText", _Get_langstr(1078))
			Case $ISN_Toolbar_ColorToolbox
				DllStructSetData($tInfo, "aText", _Get_langstr(651))
			Case $ISN_Toolbar_CloseProject
				DllStructSetData($tInfo, "aText", _Get_langstr(41))
			Case $ISN_Toolbar_UDFManager
				DllStructSetData($tInfo, "aText", _Get_langstr(1408))
			Case $ISN_Toolbar_PluginSlot1
				DllStructSetData($tInfo, "aText", _AdvancedISNPlugin_get_name(1))
			Case $ISN_Toolbar_PluginSlot2
				DllStructSetData($tInfo, "aText", _AdvancedISNPlugin_get_name(2))
			Case $ISN_Toolbar_PluginSlot3
				DllStructSetData($tInfo, "aText", _AdvancedISNPlugin_get_name(3))
			Case $ISN_Toolbar_PluginSlot4
				DllStructSetData($tInfo, "aText", _AdvancedISNPlugin_get_name(4))
			Case $ISN_Toolbar_PluginSlot5
				DllStructSetData($tInfo, "aText", _AdvancedISNPlugin_get_name(5))
			Case $ISN_Toolbar_PluginSlot6
				DllStructSetData($tInfo, "aText", _AdvancedISNPlugin_get_name(6))
			Case $ISN_Toolbar_PluginSlot7
				DllStructSetData($tInfo, "aText", _AdvancedISNPlugin_get_name(7))
			Case $ISN_Toolbar_OpenExternalFile
				DllStructSetData($tInfo, "aText", _Get_langstr(509))
		EndSwitch
	EndIf

	;Tooltips für Toolbar MIT SKIN!
	If $hWndFrom = $hToolbar Then
		If $iCode = $NM_LDOWN And $Skin_is_used = "true" Then ToolTip("") ;Tooltip löschen
		If $iCode = $TBN_HOTITEMCHANGE And $Skin_is_used = "true" Then
			$tNMTBHOTITEM = DllStructCreate($tagNMTBHOTITEM, $ilParam)
			$iOld = DllStructGetData($tNMTBHOTITEM, "idOld")
			$iNew = DllStructGetData($tNMTBHOTITEM, "idNew")
			$g_iItem = $iNew
			$iFlags = DllStructGetData($tNMTBHOTITEM, "dwFlags")
			If BitAND($iFlags, $HICF_LEAVING) = $HICF_LEAVING Then
				ToolTip("") ;Tooltip löschen
			Else
				$winpos = _WinGetPos($Studiofenster)
				$winpos_clientsize = _WinGetClientSize($Studiofenster)
				$aRect = _GUICtrlToolbar_GetButtonRect($hToolbar, $iNew)

				;Deaktivierte Buttons ignorieren
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $iNew), $TBSTATE_ENABLED) Then
					ToolTip("")
					Return $GUI_RUNDEFMSG
				EndIf

				Switch $iNew

					Case $ISN_Toolbar_NewFile ;new file
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(43), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_NewFolder ;new folder
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(46), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ImportFiles ;import
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(44), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ExportFile ;export
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(49), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_DeleteFile ;löschen
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(45), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_RefreshProjecttree ;projecttree
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(53), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_Testproject ;testproject
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(50), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_Compile ;Projekt kompilieren
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(52), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ProjectProperties ;Projekt Eigenschaften
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(51), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_Save ;speichern
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(54), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_Undo ;undo
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(55), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_Redo ;redo
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(56), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_CloseTab ;closetab
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(80), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_TestScript ;testscript
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(82), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_StopScript ;stopscript
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(106), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ToggleSearch ;search
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(85), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_Au3SyntaxCheck ;syntaxcheck
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(108), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_TidySource ;tidy
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(327), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ImportFolder ;import folder
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(455), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ToggleFullscreen ;fullscreenmode
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(457), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_Macros ;macros
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(519), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_CommentOut ;comment out
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(328), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_WindowInfoTool ;window info tool
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(609), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_MacroSlot1 ;macro 1
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Macroslot_get_name(1), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_MacroSlot2 ;macro 2
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Macroslot_get_name(2), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_MacroSlot3 ;macro 3
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Macroslot_get_name(3), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_MacroSlot4 ;macro 4
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Macroslot_get_name(4), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_MacroSlot5 ;macro 5
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Macroslot_get_name(5), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_MacroSlot6 ;macro 6
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Macroslot_get_name(6), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_MacroSlot7 ;macro 7
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Macroslot_get_name(7), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_SaveAllTabs ;save all tabs
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(649), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ChangelogManager
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(911), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ISNSettings
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(42), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ProjectSettings
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(1078), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_ColorToolbox
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(651), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_CloseProject
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(41), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_UDFManager
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_Get_langstr(1408), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_PluginSlot1
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_AdvancedISNPlugin_get_name(1), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_PluginSlot2
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_AdvancedISNPlugin_get_name(2), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_PluginSlot3
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_AdvancedISNPlugin_get_name(3), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_PluginSlot4
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_AdvancedISNPlugin_get_name(4), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_PluginSlot5
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_AdvancedISNPlugin_get_name(5), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_PluginSlot6
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_AdvancedISNPlugin_get_name(6), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

					Case $ISN_Toolbar_PluginSlot7
						If IsArray($winpos) And IsArray($winpos_clientsize) And IsArray($aRect) Then ToolTip(_AdvancedISNPlugin_get_name(7), $winpos[0] + $aRect[2], $winpos[1] + ($winpos[3] - $winpos_clientsize[1]) + $aRect[3], "", 0)

				EndSwitch

			EndIf

		EndIf
	EndIf
EndFunc   ;==>_ISN_WM_NOTIFY_Tooltips



Func _ISN_WM_NOTIFY_TVExplorer($hWnd, $iMsg, $iwParam, $ilParam)
;~	Local $tNMTREEVIEW = DllStructCreate($tagNMTREEVIEW, $ilParam)


	If @AutoItX64 Then
		Local $tNMTREEVIEW = DllStructCreate($tagNMHDR & ';uint Aligment1;uint Action;uint Aligment2;uint OldMask;ptr OldhItem;uint OldState;uint OldStateMask;ptr OldText;int OldTextMax;int OldImage;int OldSelectedImage;int OldChildren;lparam OldParam;uint Aligment3;uint NewMask;ptr NewhItem;uint NewState;uint NewStateMask;ptr NewText;int NewTextMax;int NewImage;int NewSelectedImage;int NewChildren;lparam NewParam;int X; int Y', $ilParam)
	Else
		Local $tNMTREEVIEW = DllStructCreate($tagNMHDR & ';uint Action;uint OldMask;ptr OldhItem;uint OldState;uint OldStateMask;ptr OldText;int OldTextMax;int OldImage;int OldSelectedImage;int OldChildren;lparam OldParam;uint NewMask;ptr NewhItem;uint NewState;uint NewStateMask;ptr NewText;int NewTextMax;int NewImage;int NewSelectedImage;int NewChildren;lparam NewParam;int X; int Y', $ilParam)
	EndIf
	Local $hTV = DllStructGetData($tNMTREEVIEW, 'hWndFrom')
	Local $Index = _TV_Index($hTV)

	If (Not $Index) Or ($tvData[$Index][27]) Then
	    IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_TVExplorer) then _Write_ISN_Debug_Console("TVExplorer WM_NOTIFY_TVExplorer stoped with GUI_RUNDEFMSG", $ISN_Debug_Console_Errorlevel_Warning)
		Return 'GUI_RUNDEFMSG'
	EndIf



	Local $hItem = DllStructGetData($tNMTREEVIEW, 'NewhItem')
	Local $hPrev = DllStructGetData($tNMTREEVIEW, 'OldhItem')
	Local $state = DllStructGetData($tNMTREEVIEW, 'NewState')
	Local $ID = DllStructGetData($tNMTREEVIEW, 'Code')
	Local $Mode = _WinAPI_SetErrorMode(BitOR($SEM_FAILCRITICALERRORS, $SEM_NOOPENFILEERRORBOX))
	Local $tPOINT, $flag, $path
	Local $tTVHTI

	Do
		Switch $ID

			Case $TVN_ITEMEXPANDINGW
				$Current_TVExplorer_TreeView = $hTV
;~ 				If $tvData[$Index][28] Then
;~ 					ExitLoop
;~ 				EndIf
				If Not _GUICtrlTreeView_ExpandedOnce($hTV, $hItem) Then
;~					_GUICtrlTreeView_SetState($hTV, $hItem, $TVIS_EXPANDEDONCE, 1)
					_TV_Send(3, $Index, $hItem)
				EndIf
			Case $TVN_ITEMEXPANDEDW
				$Current_TVExplorer_TreeView = $hTV
				$path = _TV_GetPath($Index, $hItem)
				If BitAND($TVIS_EXPANDED, $state) Then
					$flag = 1
				Else
					$flag = 0
				EndIf
				If FileExists($path) Then
					_TV_SetImage($hTV, $hItem, _TV_AddIcon($Index, $path, $flag))
				Else
					_TV_Send(4, $Index, $hItem)
				EndIf
			Case $TVN_SELCHANGEDW
				$Current_TVExplorer_TreeView = $hTV
				If BitAND($TVIS_SELECTED, $state) Then
					_TV_Send(4, $Index, $hItem)
				EndIf
			Case $TVN_DELETEITEMW
				$Current_TVExplorer_TreeView = $hTV
				_TV_DeleteShortcut($Index, $hPrev)
			Case -5 ; NM_RCLICK
			$Current_TVExplorer_TreeView = $hTV
;~ 				If $tvData[$Index][28] Then
;~ 					ExitLoop
;~ 				EndIf
				$tPOINT = _WinAPI_GetMousePos(1, $hTV)
				$tTVHTI = _GUICtrlTreeView_HitTestEx($hTV, DllStructGetData($tPOINT, 1), DllStructGetData($tPOINT, 2))
				$hItem = DllStructGetData($tTVHTI, 'Item')
				If BitAND(DllStructGetData($tTVHTI, 'Flags'), $TVHT_ONITEM) Then
					_GUICtrlTreeView_SelectItem($hTV, $hItem)
					$path = _TV_GetPath($Index, $hItem)
					If FileExists($path) Then
						_TV_SetSelected($Index, $hItem)
						_TV_Send(7, $Index, $hItem)
					Else
						_TV_Send(4, $Index, $hItem)
					EndIf
				EndIf
			Case -3 ; NM_DBLCLK
			$Current_TVExplorer_TreeView = $hTV
;~ 				If $tvData[$Index][28] Then
;~ 					ExitLoop
;~ 				EndIf
				$tPOINT = _WinAPI_GetMousePos(1, $hTV)
				$tTVHTI = _GUICtrlTreeView_HitTestEx($hTV, DllStructGetData($tPOINT, 1), DllStructGetData($tPOINT, 2))
				$hItem = DllStructGetData($tTVHTI, 'Item')
				If BitAND(DllStructGetData($tTVHTI, 'Flags'), $TVHT_ONITEM) Then
					$path = _TV_GetPath($Index, $hItem)
					If Not _WinAPI_PathIsDirectory($path) Then
						_TV_Send(6, $Index, $hItem)
					EndIf
				EndIf
			Case $TVN_BEGINDRAGA, $TVN_BEGINDRAGW ;Beginne Drag&Drop Aktion
			$Current_TVExplorer_TreeView = $hTV
				Local $zielpfad = ""
				Local $onlyTextDrag = 0
				Local $Quelldatei = _GUICtrlTVExplorer_GetSelected($hTV)
				$hItemHover = TreeItemFromPoint($hTV)

				;On click Drag fix
				If $Quelldatei <> _TV_GetPath($Index, $hItemHover) Then
					MouseUp("primary")
					Return $GUI_RUNDEFMSG
				EndIf

				Local $copy_mode = 0
				While _IsPressed("01", $user32)
					Sleep(50)
					$MausPosition = MouseGetPos()
					$hItemHover = TreeItemFromPoint($hTV)
					$zielpfad = _TV_GetPath($Index, $hItemHover)
					$onlyTextDrag = 0
					;Kopie erstellen wenn STRG gedrückt gehalten wird
					If _IsPressed("11", $user32) Then
						$copy_mode = 1
					Else
						$copy_mode = 0
					EndIf

					If IsArray($MausPosition) Then
						Local $hwnd_UnderMouse = _GetHwndUnderMouse()
						If _WinAPI_GetClassName($hwnd_UnderMouse) = "Scintilla" Then
							If _WinAPI_PathIsDirectory($Quelldatei) Then
								GUISetCursor(7, 1, $hWnd)
								ToolTip("")
								$onlyTextDrag = 0
								ContinueLoop
							EndIf
							$onlyTextDrag = 1
							If _WinAPI_GetFocus() <> $hwnd_UnderMouse Then _WinAPI_SetFocus($hwnd_UnderMouse)
							ToolTip(_Get_langstr(1424), $MausPosition[0] + 5, $MausPosition[1] + 5, "", 0, 0)
							Local $WP = _WinGetPos($hwnd_UnderMouse)
							$MausPosition[0] -= $WP[0]
							$MausPosition[1] -= $WP[1]
							SendMessage($hwnd_UnderMouse, $SCI_GOTOPOS, SendMessage($hwnd_UnderMouse, $SCI_POSITIONFROMPOINT, $MausPosition[0] - 5, $MausPosition[1]), 0)
							GUISetCursor(2, 1, $hwnd_UnderMouse)


						Else
							$onlyTextDrag = 0
							If _Pruefe_Ob_Drag_and_Drop_erlaubt_ist($Quelldatei, $zielpfad, $copy_mode) = 1 Then
								GUISetCursor(2, 1, $hWnd)
								If $copy_mode = 0 Then
									ToolTip(_Get_langstr(152) & " " & StringReplace($zielpfad, $Offenes_Projekt & "\", ""), $MausPosition[0] + 10, $MausPosition[1], StringTrimLeft($Quelldatei, StringInStr($Quelldatei, "\", 0, -1)))
								Else
									ToolTip(_Get_langstr(371) & " " & StringReplace($zielpfad, $Offenes_Projekt & "\", ""), $MausPosition[0] + 10, $MausPosition[1], StringTrimLeft($Quelldatei, StringInStr($Quelldatei, "\", 0, -1)))
								EndIf
							Else
								GUISetCursor(7, 1, $hWnd)
								ToolTip("")
							EndIf
						EndIf
					EndIf

					If $hItemHover = 1 Then
						;nix
					Else
						_SendMessage($hTV, $TVM_SELECTITEM, $TVGN_DROPHILITE, $hItemHover) ;add DropTarget
					EndIf
				WEnd

				_SendMessage($hTV, $TVM_SELECTITEM, $TVGN_DROPHILITE, 0) ;remove DropTarget
				ToolTip("")
				GUISetCursor(2, 0, $hWnd)
				If $onlyTextDrag = 0 Then
					_Try_to_move_file_drag_and_Drop($Quelldatei, $zielpfad, $copy_mode)
				Else
					Local $RelativePath = ""
					GUISetCursor(2, 0, $hwnd_UnderMouse)
					$SCE_Res = _ArraySearch($SCE_EDITOR, $hwnd_UnderMouse)
					If $SCE_Res <> -1 And Not _ISN_IsPathInAnManagedIncludeDirectory($Quelldatei) Then
						$RelativePath = $Datei_pfad[$SCE_Res]
						If $RelativePath = $Quelldatei Then Return $GUI_RUNDEFMSG ;Can not include in same file
						$Quelldatei = _PathGetRelative($RelativePath, $Quelldatei)
						If Not @error And StringLeft($Quelldatei, 3) = "..\" Then $Quelldatei = StringTrimLeft($Quelldatei, 3)
					EndIf


					If _ISN_IsPathInAnManagedIncludeDirectory($Quelldatei) Then
						Sci_InsertText($hwnd_UnderMouse, Sci_GetCurrentPos($hwnd_UnderMouse), '#include <' & _ISN_FileInManagedIncludeDirectory_TrimIncludeDir($Quelldatei) & '>' & @CRLF)
					Else
						Sci_InsertText($hwnd_UnderMouse, Sci_GetCurrentPos($hwnd_UnderMouse), '#include "' & StringReplace($Quelldatei, _WinAPI_PathAddBackslash($Offenes_Projekt), "") & '"' & @CRLF)
					EndIf
					Return $GUI_RUNDEFMSG ;Stop here
				EndIf

		EndSwitch
	Until 1
	_WinAPI_SetErrorMode($Mode)
EndFunc   ;==>_ISN_WM_NOTIFY_TVExplorer


Func _ISN_WM_NOTIFY_Listviews($hWnd, $iMsg, $iwParam, $ilParam)
	$tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")
	Local $nID = BitAND($iwParam, 0x0000FFFF)

	Switch $iCode


		Case $LVN_KEYDOWN
			If _IsPressed("26", $user32) Or _IsPressed("28", $user32) Then
				If $nID = $changelogmanager_listview Then AdlibRegister("_changelogmanager_lade_eintrag", 1)
				If $nID = $Projects_Listview_projectman Then AdlibRegister("_Load_Details_Manager", 1)
				If $nID = $Pugins_Listview Then AdlibRegister("_load_plugindetails", 1)
				If $nID = $config_skin_list Then AdlibRegister("_load_skindetails", 1)
			EndIf


			;Färbung für Listviews
		Case $NM_CUSTOMDRAW
			Local $tNMLVCUSTOMDRAW = DllStructCreate($tagNMLVCUSTOMDRAW, $ilParam)
			Local $dwDrawStage = DllStructGetData($tNMLVCUSTOMDRAW, "dwDrawStage")
			Switch $dwDrawStage
				Case $CDDS_PREPAINT
					Return $CDRF_NOTIFYITEMDRAW
				Case $CDDS_ITEMPREPAINT
					Return $CDRF_NOTIFYSUBITEMDRAW
				Case BitOR($CDDS_ITEMPREPAINT, $CDDS_SUBITEM)
					Local $iSubItem = DllStructGetData($tNMLVCUSTOMDRAW, "iSubItem")
					Local $dwItemSpec = DllStructGetData($tNMLVCUSTOMDRAW, "dwItemSpec")
					Local $hDC = DllStructGetData($tNMLVCUSTOMDRAW, "HDC")
					Switch $nID

						; DllStructSetData( $tNMLVCUSTOMDRAW, "ClrText", Listview_ColorConvert(0x000000))
						Case $quick_view_ToDoList_Listview

							$color = _ToDo_Liste_Kategoriefarbe_nach_Item_herausfinden($quick_view_ToDoList_Listview, $dwItemSpec)
							If $color <> "" Then DllStructSetData($tNMLVCUSTOMDRAW, "ClrTextBk", Listview_ColorConvert($color))

						Case $ToDoList_Listview
							$color = _ToDo_Liste_Kategoriefarbe_nach_Item_herausfinden($ToDoList_Listview, $dwItemSpec)
							If $color <> "" Then DllStructSetData($tNMLVCUSTOMDRAW, "ClrTextBk", Listview_ColorConvert($color))

						Case $Category_Manager_Listview
							$color = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", _GUICtrlListView_GetItemText($Category_Manager_Listview, $dwItemSpec, 0) & "_color", "")
							If $color <> "" Then DllStructSetData($tNMLVCUSTOMDRAW, "ClrTextBk", Listview_ColorConvert($color))

						Case $ParameterEditor_ListView
							$color = ""
							If _GUICtrlListView_GetItemText($ParameterEditor_ListView, $dwItemSpec, 0) = _Get_langstr(1359) Or _GUICtrlListView_GetItemText($ParameterEditor_ListView, $dwItemSpec, 0) = _Get_langstr(1360) Then $color = $scripteditor_rowcolour
							If $color <> "" Then DllStructSetData($tNMLVCUSTOMDRAW, "ClrTextBk", Listview_ColorConvert($color))

						Case $ISN_VariablesSelector_Listview
							If Not StringInStr(_GUICtrlListView_GetItemText($ISN_VariablesSelector_Listview, $dwItemSpec, 0), "%") Then _WinAPI_SelectObject($hDC, $ListViewBoldFont)



					EndSwitch
					Return $CDRF_NEWFONT
			EndSwitch




		Case $LVN_BEGINDRAG
			$tNMLISTVIEW = DllStructCreate($tagNMLISTVIEW, $ilParam)
			$iEndIndex = DllStructGetData($tNMLISTVIEW, 'Item')
			$iEndSubIndex = DllStructGetData($tNMLISTVIEW, 'SubItem')
			Switch $nID

				;Bei folgenden Listviews gibt es eine Aktion wenn etwas via Dag and Drop versucht wird. Das ganze geht an die $LVN_HOTTRACK weiter...
				Case $quick_view_ToDoList_Listview
					$Listview_Drag_aktiv = 1

				Case $ToDoList_Listview
					$Listview_Drag_aktiv = 1

				Case $Projects_Listview_projectman
					$Listview_Drag_aktiv = 1

				Case $ISN_VariablesSelector_Listview
					MouseUp("primary")


			EndSwitch


		Case $LVN_HOTTRACK
			If $Listview_Drag_aktiv = 1 Then ;Nur wen bereits eine Drag and Drop aktion läuft
				$Listview_Drag_aktiv = 0
				$tNMLISTVIEW = DllStructCreate($tagNMLISTVIEW, $ilParam)
				$iEndIndex = DllStructGetData($tNMLISTVIEW, 'Item')
				$iEndSubIndex = DllStructGetData($tNMLISTVIEW, 'SubItem')

				Switch $nID

					Case $quick_view_ToDoList_Listview
						_ToDo_Liste_Aufgabe_in_andere_Kategorie_verschieben($quick_view_ToDoList_Listview, _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, $iEndIndex, 1))

					Case $ToDoList_Listview
						_ToDo_Liste_Aufgabe_in_andere_Kategorie_verschieben($ToDoList_Listview, _GUICtrlListView_GetItemText($ToDoList_Listview, $iEndIndex, 1))

					Case $Projects_Listview_projectman
						_Projectmanager_move_project_to_new_location_drag(_GUICtrlListView_GetItemText($Projects_Listview_projectman, $iEndIndex, 3))

				EndSwitch
			EndIf




		Case $NM_CLICK, $LVN_ITEMCHANGED

			If $nID = $listview_projectrules Then _load_ruledetails()
			If $nID = $Pugins_Listview Then _load_plugindetails()
			If $nID = $config_skin_list Then _load_skindetails()
			If $nID = $Projects_Listview_projectman Then _Load_Details_Manager()
			If $nID = $changelogmanager_listview Then _changelogmanager_lade_eintrag()
			If $nID = $FuncListview Then GUICtrlSetData($Funcinput, _GUICtrlListView_GetItemText($FuncListview, _GUICtrlListView_GetSelectionMark($FuncListview), 0))
			If $nID = $ISN_VariablesSelector_Listview Then _ISN_VariablesSelector_SelectItem()
			If $nID = $ParameterEditor_ListView And $iCode <> $LVN_ITEMCHANGED Then _Parameter_Editor_Listview_select_row()




		Case $NM_DBLCLK
			If $nID = $Projects_Listview Then _Try_to_Open_project()
			If $nID = $new_rule_triggerlist Then _edit_trigger()
			If $nID = $listview_projectrules Then _Editiere_Regel()
			If $nID = $makro_auswaehlen_listview Then _AU3_mit_vorhandenen_Makro_kompilieren_Makro_auswaehlen()
			If $nID = $Projects_Listview_projectman Then _Try_to_Open_projectman()
			If $nID = $vorlagen_Listview_projectman Then _Try_to_Open_template()
			If $nID = $new_rule_actionlist Then _edit_action()
			If $nID = $settings_hotkeylistview Then _show_Edit_Hotkey()
			If $nID = $einstellungen_toolbar_verfuegbareelemente_listview Then _Einstellungen_Toolbar_Eintrag_hinzufuegen()
			If $nID = $einstellungen_toolbar_aktiveelemente_listview Then _Einstellungen_Toolbar_entferne_Eintrag()
			If $nID = $in_dateien_suchen_gefundene_elemente_listview Then _In_Datei_suchen_Eintrag_oeffnen()
			If $nID = $FuncListview Then
				GUICtrlSetData($Funcinput, _GUICtrlListView_GetItemText($FuncListview, _GUICtrlListView_GetSelectionMark($FuncListview), 0))
				_func_select_ok()
			EndIf
			If $nID = $Category_Manager_Listview Then _ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_bearbeiten()
			If $nID = $ToDoList_Listview Then _ToDo_Liste_Aufgabe_Bearbeiten_Manager()
			If $nID = $quick_view_ToDoList_Listview Then _ToDo_Liste_Aufgabe_Bearbeiten_QuickView()
			If $nID = $ISN_VariablesSelector_Listview Then _ISN_VariablesSelector_BeginDragText()



		Case $LVN_COLUMNCLICK ; A column was clicked
			$tInfo = DllStructCreate($tagNMLISTVIEW, $ilParam)
			$iColumnIndex = DllStructGetData($tInfo, "SubItem")
			If $nID = $Projects_Listview Then _HeaderSort($Projects_Listview, $iColumnIndex)
			If $nID = $Projects_Listview_projectman Then _Sortiere_Listview($Projects_Listview_projectman, $iColumnIndex)
			If $nID = $vorlagen_Listview_projectman Then _HeaderSort($vorlagen_Listview_projectman, $iColumnIndex)
			If $nID = $FuncListview Then _HeaderSort($FuncListview, $iColumnIndex)
			If $nID = $settings_hotkeylistview Then _Sortiere_Listview($settings_hotkeylistview, $iColumnIndex)


		Case $NM_RCLICK
			If $nID = $Projects_Listview_projectman Then _Load_Details_Manager()

			$tPOINT = _WinAPI_GetMousePos(True, $Studiofenster)
			Local $iX = DllStructGetData($tPOINT, "X")
			Local $iY = DllStructGetData($tPOINT, "Y")

			Local $aPos = _ControlGetPos($Studiofenster, "", $htab)

			Local $aHit = _GUICtrlTab_HitTest($htab, $iX - $aPos[0], $iY - $aPos[1])
			If $aHit[0] <> -1 And _GUICtrlTab_GetCurFocus($htab) <> -1 Then _GUICtrlTab_SetCurSel($htab, _GUICtrlTab_GetCurFocus($htab))
			If _GUICtrlTab_GetCurFocus($htab) = -1 And _GUICtrlTab_GetItemCount($htab) > 0 Then
				_GUICtrlTab_SetCurSel($htab, 0)
				_Show_Tab(0)
			EndIf

	EndSwitch
EndFunc   ;==>_ISN_WM_NOTIFY_Listviews




Func _WM_NOTIFY_EDITOR($hWnd, $iMsg, $iwParam, $ilParam)
	If $Can_open_new_tab = 0 Then Return $GUI_RUNDEFMSG

	Local $tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	Local $iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	Local $iCode = DllStructGetData($tNMHDR, "Code")
	Local $nID = BitAND($iwParam, 0x0000FFFF)

	;-----------------------------------SCRIPTEDITOR
	Local $tagNMHDR, $event
	Local $structNMHDR = DllStructCreate("hwnd hWndFrom;int IDFrom;int Code", $ilParam) ; tagNMHDR
	Local $sClassName = DllCall("User32.dll", "int", "GetClassName", "hwnd", DllStructGetData($structNMHDR, 1), "str", "", "int", 512)

	$sClassName = $sClassName[2]

	If $sClassName <> "Scintilla" Then Return $GUI_RUNDEFMSG
	$structNMHDR = DllStructCreate($tagSCNotification, $ilParam)
	If @error Then Return $GUI_RUNDEFMSG


	Global $SCI_Zeile
	Local $hWndFrom = DllStructGetData($structNMHDR, 1)
	Local $Sci = $hWndFrom
	If Not IsHWnd($Sci) Then $Sci = HWnd($Sci)
	Local $IdFrom = DllStructGetData($structNMHDR, 2)
	Local $event = DllStructGetData($structNMHDR, 3)
	Local $position = DllStructGetData($structNMHDR, 4)
	Local $ch = DllStructGetData($structNMHDR, 5)
	Local $modificationType = DllStructGetData($structNMHDR, 7)
	Local $updated = DllStructGetData($structNMHDR, 23)
	Local $Char = DllStructGetData($structNMHDR, 8)
	Local $Length = DllStructGetData($structNMHDR, 9)
	Local $selections = SendMessage($Sci, $SCI_GETSELECTIONS, 0, 0)

	If $Sci = $ParameterEditor_Vorschau_Fertiger_Befehl_SCE Or $Sci = $QuickView_Notes_Scintilla Then Return $GUI_RUNDEFMSG


;~ 	#cs
;~
;~Local $modifiers = DllStructGetData($structNMHDR, 6)
;~ 		Local $char = DllStructGetData($structNMHDR, 8)
;~ 		Local $length = DllStructGetData($structNMHDR, 9)
;~ 		Local $linesAdded = DllStructGetData($structNMHDR, 10)

;~ 		Local $message = DllStructGetData($structNMHDR, 11)
;~ 		Local $uptr_t = DllStructGetData($structNMHDR, 12)
;~ 		Local $sptr_t = DllStructGetData($structNMHDR, 13)
;~ 		Local $Line = DllStructGetData($structNMHDR, 14)

;~ 		Local $foldLevelNow = DllStructGetData($structNMHDR, 15)
;~ 		Local $foldLevelPrev = DllStructGetData($structNMHDR, 16)
;~ 		Local $margin = DllStructGetData($structNMHDR, 17)
;~ 		Local $listType = DllStructGetData($structNMHDR, 18)

;~ 		Local $X = DllStructGetData($structNMHDR, 19)
;~ 		Local $Y = DllStructGetData($structNMHDR, 20)
;~ 	#ce



;~ 	ConsoleWrite("lll" & _WinAPI_GetClassName($Sci) & @CRLF)
	Local $line_number = SendMessage($Sci, $SCI_LINEFROMPOSITION, $position, 0)


	;Wenn mehr als eine Zeile Markiert ist -> überstringe diese Funktion
;~ 	if SendMessage($Sci, $SCI_LINEFROMPOSITION, SendMessage($Sci, $SCI_GETSELECTIONSTART, 0, 0), 0) <> SendMessage($Sci, $SCI_LINEFROMPOSITION, SendMessage($Sci, $SCI_GETSELECTIONEND, 0, 0), 0) Then
;~ 	  Return 'GUI_RUNDEFMSG'
;~     endif






	;falls sich aktuelle zeile ändert -> weg mit dem colourpicker
	If Sci_GetLineFromPos($Sci, Sci_GetCurrentPos($Sci)) <> $SCIE_letzte_zeile Then
		$farb_picker_GUIstate = WinGetState($mini_farb_picker_GUI, "")
		If BitAND($farb_picker_GUIstate, 2) Then _Colour_Calltipp_Set_State("hide")
	EndIf
	$SCIE_letzte_zeile = Sci_GetLineFromPos($Sci, Sci_GetCurrentPos($Sci))


	;Select
	;Case $hwndFrom = $Sci
	;If IsHWnd($Sci) Then
	Local $Word, $WordPos, $CurrentLine, $PreviousLine, $Tabs, $TabsAdd, $style, $CurrentPos, $pos, $Replace, $AllVariables, $AllVariablesSplit, $AllWords, $err, $Variable
	Switch $event

		Case $SCN_CALLTIPCLICK


			If SendMessage($Sci, $SCI_CALLTIPACTIVE, 0, 0) Then
				Switch $position

					Case 1
						If IsArray($SCI_sCallTipFoundIndices) And $SCI_sCallTipSelectedIndice > 0 Then
							$SCI_sCallTipSelectedIndice -= 1
							$SCI_sCallTip = Chr(1) & $SCI_sCallTipSelectedIndice + 1 & "/" & UBound($SCI_sCallTipFoundIndices) & Chr(2) & $SCI_sCallTip_Array[$SCI_sCallTipFoundIndices[$SCI_sCallTipSelectedIndice]]
							$SCI_sCallTip = StringRegExpReplace(StringReplace($SCI_sCallTip, ")", ")" & @LF, 1), "([.:])", "$1" & @LF)
							SendMessageString($Sci, $SCI_CALLTIPSHOW, $SCI_sCallTipPos, $SCI_sCallTip)
						EndIf

					Case 2
						If IsArray($SCI_sCallTipFoundIndices) And $SCI_sCallTipSelectedIndice < UBound($SCI_sCallTipFoundIndices) - 1 Then
							$SCI_sCallTipSelectedIndice += 1
							$SCI_sCallTip = Chr(1) & $SCI_sCallTipSelectedIndice + 1 & "/" & UBound($SCI_sCallTipFoundIndices) & Chr(2) & $SCI_sCallTip_Array[$SCI_sCallTipFoundIndices[$SCI_sCallTipSelectedIndice]]
							$SCI_sCallTip = StringRegExpReplace(StringReplace($SCI_sCallTip, ")", ")" & @LF, 1), "([.:])", "$1" & @LF)
							SendMessageString($Sci, $SCI_CALLTIPSHOW, $SCI_sCallTipPos, $SCI_sCallTip)
						EndIf
				EndSwitch
			EndIf

		Case $SCN_DOUBLECLICK
			If $Sci = $Debug_log Then
				_trytofinderror()
				Return $GUI_RUNDEFMSG
			EndIf
			$Selection = Sci_GetSelection($Sci)
			If IsArray($Selection) Then
				If $SkriptEditor_Doppelklick_ParameterEditor = "true" And $Tools_Parameter_Editor_aktiviert = "true" Then
					$Aktuelles_Wort_Doppelclick = StringStripWS(SCI_GetTextRange($Sci, $Selection[0], $Selection[1]), 3)
					$Aktuelles_Wort_Doppelclick = StringReplace($Aktuelles_Wort_Doppelclick, "(", "")
					$Aktuelles_Wort_Doppelclick = StringReplace($Aktuelles_Wort_Doppelclick, ")", "")
					_Pruefe_Doppelklickwort_im_Skripteditor($Aktuelles_Wort_Doppelclick, $Selection[1])
				EndIf
			EndIf






		Case $SCN_CHARADDED

			If SendMessage($Sci, $SCI_GETREADONLY, 0, 0) Then
				$ParameterEditor_GUI_State = WinGetState($ParameterEditor_GUI, "")
				If BitAND($ParameterEditor_GUI_State, 2) And $Sci <> $ParameterEditor_SCIEditor Then
					$aktuelle_pos_SCE_Window = _WinGetPos($Sci)
					$aktuelle_pos = Sci_GetCurrentPos($Sci)
					$x = SendMessage($Sci, $SCI_POINTXFROMPOSITION, 0, $aktuelle_pos) + $aktuelle_pos_SCE_Window[0]
					$y = SendMessage($Sci, $SCI_POINTYFROMPOSITION, 0, $aktuelle_pos) + $aktuelle_pos_SCE_Window[1] + 10
					_ISNTooltip_with_Timer(StringReplace(_Get_langstr(1296), "%1", WinGetTitle($ParameterEditor_GUI)), $x, $y, _Get_langstr(25), 3, 1)
				EndIf
				Return $GUI_RUNDEFMSG
			EndIf

			If $selections > 1 Then Return $GUI_RUNDEFMSG ;Stop here at multi coursor

			;Stuff for AutoFormat Correction (thx to jacobslusser)
			$caretPos = Sci_GetCurrentPos($Sci)
			$docStart = $caretPos == 1
			$docEnd = $caretPos == Sci_GetLenght($Sci)
			$charPrev = $docStart ? Sci_GetChar($Sci, $caretPos) : Sci_GetChar($Sci, $caretPos - 2)
			$charNext = Sci_GetChar($Sci, $caretPos)
			$isCharPrevBlank = $charPrev == ' ' Or $charPrev == @TAB Or $charPrev == @CRLF Or $charPrev == @CR
			$isCharNextBlank = $charNext == ' ' Or $charNext == @TAB Or $charNext == @CRLF Or $charNext == @CR Or $docEnd
			$isEnclosed = ($charPrev == '(' And $charNext == ')') Or ($charPrev == '{' And $charNext == '}') Or ($charPrev == '[' And $charNext == ']')
			$isEnclosed2 = ($charPrev == '"' And $charNext == '"') Or ($charPrev == "'" And $charNext == "'")
			$isSpaceEnclosed = ($charPrev == '(' And $isCharNextBlank) Or ($isCharPrevBlank And $charNext == ')') Or ($charPrev == '{' And $isCharNextBlank) Or ($isCharPrevBlank And $charNext == '}') Or ($charPrev == '[' And $isCharNextBlank) Or ($isCharPrevBlank And $charNext == ']')
			$charNextIsCharOrString = $charNext == '"' Or $charNext == "'"
			$isCharOrString = ($isCharPrevBlank And $isCharNextBlank) Or $isEnclosed Or $isSpaceEnclosed
			$isCharOrString2 = ($isCharPrevBlank) Or $isEnclosed Or $isSpaceEnclosed
			$QuoteAllowed = ($charPrev == '(' Or $charNext == ')') Or ($charPrev == ',' Or $charNext == ',') Or $isCharNextBlank
			Local $CloseBracket_Offset = 0
			;


			If SendMessage($Sci, $SCI_GETLEXER, 0, 0) = $SCLEX_AU3 Then
				Switch Chr($ch)


					Case "("
						Sleep(10) ;Style bugfix..without this $SCI_GETSTYLEAT returns 0 ?!?!?
						If _Is_Comment($Sci) Then Return $GUI_RUNDEFMSG
						If $ScriptEditor_Autocomplete_Brackets = "true" And $Scintilla_LastInsertedChar = Chr($ch) And SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 1, 0) <> $SCE_AU3_STRING Then
							_Scintilla_check_Brace_highlighting($Sci)
							If ($bracePos1 = -1 Or $bracePos2 = -1) Or (SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 2, 0) = $SCE_AU3_FUNCTION Or SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 2, 0) = $SCE_AU3_UDF) Then
								$CloseBracket_Offset = _Scintilla_FindBracketOffsetForAutocomplete($Sci, Sci_GetCurrentPos($Sci), Chr($ch))
								Sci_InsertText($Sci, Sci_GetCurrentPos($Sci) + $CloseBracket_Offset, ")")
								_Scintilla_check_Brace_highlighting($Sci, -1)
							EndIf
						EndIf
						_Scintilla_CallTip_ShowHide_Check($Sci)


					Case ","
						Sleep(10) ;Style bugfix..without this $SCI_GETSTYLEAT returns 0 ?!?!?
						If SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 1, 0) = $SCE_AU3_OPERATOR And $ScriptEditor_UseAutoFormat_Correction = "true" And Sci_GetChar($Sci, Sci_GetCurrentPos($Sci)) <> " " Then
							Sci_AddText($Sci, ' ')
						EndIf
						If _Is_Comment($Sci) Then Return $GUI_RUNDEFMSG
						_Scintilla_CallTip_ShowHide_Check($Sci)

					Case "&", "=", "+", "/", "*", ">", "?", ":"
						Sleep(10) ;Style bugfix..without this $SCI_GETSTYLEAT returns 0 ?!?!?
						If SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 1, 0) = $SCE_AU3_OPERATOR And $ScriptEditor_UseAutoFormat_Correction = "true" And Sci_GetChar($Sci, Sci_GetCurrentPos($Sci)) <> " " Then Sci_AddText($Sci, ' ')


					Case ")"
						_Colour_Calltipp_Set_State("hide")
						If SendMessage($Sci, $SCI_CALLTIPACTIVE, 0, 0) Then SendMessage($Sci, $SCI_CALLTIPCANCEL, 0, 0)
						_Scintilla_check_Brace_highlighting($Sci, -1)


					Case "'"
						If _Is_Comment($Sci) Then Return $GUI_RUNDEFMSG
						If ($isCharOrString2) And $ScriptEditor_Autocomplete_Brackets = "true" And $Scintilla_LastInsertedChar = Chr($ch) And $QuoteAllowed Then Sci_InsertText($Sci, Sci_GetCurrentPos($Sci), "'")

					Case "{"
						Sleep(10) ;Style bugfix..without this $SCI_GETSTYLEAT returns 0 ?!?!?
						If _Is_Comment($Sci) Then Return $GUI_RUNDEFMSG
						If ($isEnclosed2) And $ScriptEditor_Autocomplete_Brackets = "true" And $Scintilla_LastInsertedChar = Chr($ch) And SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 1, 0) <> $SCE_AU3_STRING Then
							_Scintilla_check_Brace_highlighting($Sci)
							If $bracePos1 = -1 Or $bracePos2 = -1 Then $CloseBracket_Offset = _Scintilla_FindBracketOffsetForAutocomplete($Sci, Sci_GetCurrentPos($Sci), Chr($ch))
							Sci_InsertText($Sci, Sci_GetCurrentPos($Sci) + $CloseBracket_Offset, "}")
							_Scintilla_check_Brace_highlighting($Sci, -1)
						EndIf


					Case @LF
						_Colour_Calltipp_Set_State("hide")
						If $Sci = $ParameterEditor_SCIEditor Then
							$Old = Sci_GetText($ParameterEditor_SCIEditor)
;~ 						if $autoit_editor_encoding = "2" then $Old = _ANSI2UNICODE($Old)
							$Old = StringReplace($Old, @CRLF, "")
							$Old = StringReplace($Old, @LF, "")
							$Old = StringReplace($Old, @CR, "")
							Sci_SetText($ParameterEditor_SCIEditor, $Old)
;~ 						If _IsPressed("11", $user32) Then
;~ 							_Parameter_Editor_Parameter_hinzufuegen()
;~ 						EndIf
							Return $GUI_RUNDEFMSG
						EndIf


					Case @CR
						If $AutoEnd_Keywords = "true" And $Sci <> $ParameterEditor_SCIEditor Then
							_Autocomplete_nach_Enter($Sci)
						EndIf
						_Colour_Calltipp_Set_State("hide")


					Case "<", '"', "["
						If _Is_Comment($Sci) Then Return $GUI_RUNDEFMSG
						Sleep(10) ;Style bugfix..without this $SCI_GETSTYLEAT returns 0 ?!?!?
						If Chr($ch) = "<" Then
							If SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 1, 0) = $SCE_AU3_OPERATOR And $ScriptEditor_UseAutoFormat_Correction = "true" And $Scintilla_LastInsertedChar = Chr($ch) Then
								Sci_AddText($Sci, ' ')
							EndIf
						EndIf

						_Scintilla_check_Brace_highlighting($Sci)
						If ($isCharOrString2) And $ScriptEditor_Autocomplete_Brackets = "true" And Chr($ch) = '"' And $QuoteAllowed Then Sci_InsertText($Sci, Sci_GetCurrentPos($Sci), '"')
						If $bracePos1 = -1 Or $bracePos2 = -1 Then
							$CloseBracket_Offset = _Scintilla_FindBracketOffsetForAutocomplete($Sci, Sci_GetCurrentPos($Sci), Chr($ch))
							If ($isCharOrString2) And $ScriptEditor_Autocomplete_Brackets = "true" And Chr($ch) = '<' And SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 1, 0) = $SCE_AU3_STRING Then Sci_InsertText($Sci, Sci_GetCurrentPos($Sci) + $CloseBracket_Offset, '>')
							If $ScriptEditor_Autocomplete_Brackets = "true" And Chr($ch) = '[' And $Scintilla_LastInsertedChar = Chr($ch) And SendMessage($Sci, $SCI_GETSTYLEAT, Sci_GetCurrentPos($Sci) - 1, 0) = $SCE_AU3_OPERATOR Then Sci_InsertText($Sci, Sci_GetCurrentPos($Sci) + $CloseBracket_Offset, ']')
							_Scintilla_check_Brace_highlighting($Sci, -1)
						EndIf

						;Autocomplete for includes
						If $disableautocomplete = "true" Then Return $GUI_RUNDEFMSG
						$style = SendMessage($Sci, $SCI_GETSTYLEAT, SCI_GetCurrentPos($Sci), 0)
						If Not SendMessage($Sci, $SCI_AUTOCACTIVE, 0, 0) And _
								$style <> $SCE_AU3_COMMENT And $style <> $SCE_AU3_COMMENTBLOCK _
								And $style <> $SCE_AU3_SENT Then
							_Scintilla_CallTip_ShowHide_Check($Sci)
						EndIf



					Case " "

						If SendMessage($Sci, $SCI_AUTOCACTIVE, 0, 0) And $allow_autocomplete_with_spacekey = "true" Then
							SendMessage($Sci, $SCI_AUTOCCOMPLETE, 0, 0) ;Allow autocomplete with tab key
						EndIf

						$CurrentPos = SCI_GetCurrentPos($Sci)

						If $Auto_dollar_for_declarations = "true" And Not _Is_Comment($Sci) Then
							$Letztes_Wort = SCI_GetWordFromPos($Sci, SCI_GetCurrentPos($Sci) - 2)

;~ 							$TabsAdd = _ISN_Scintilla_GenerateIndentForNextLine($Sci, 0, SCI_GetCurrentLine($Sci) - 1)

							If $Auto_dollar_for_declarations = "true" And Not StringInStr(SCI_GetLine($Sci, SCI_GetCurrentLine($Sci) - 1), "$") Then
								Switch $Letztes_Wort

									Case "enum", "global", "local", "const", "byref", "dim", "redim", "static"
										Send("$")

								EndSwitch
							EndIf


						EndIf


						$style = SendMessage($Sci, $SCI_GETSTYLEAT, $CurrentPos - 2, 0)
						If $style = $SCE_AU3_EXPAND Then
							$WordPos = SCI_GetWordPositions($Sci, $CurrentPos - 2)
							$Replace = StringRegExp($SCI_ABBREVFILE, "(?:\n|\r|\A)" & StringLower(SCI_GETTEXTRANGE($Sci, $WordPos[0], $WordPos[1])) & "=(.*)", 1)
							If Not @error Then
								$Replace = StringFormat(StringRegExpReplace($Replace[0], "\r|\n", ""))

								SCI_SetSelection($Sci, $WordPos[0], $WordPos[1] + 1)
								$WordPos[0] += StringInStr($Replace, "|", 1, 1) - 1
								If Not StringInStr($Replace, "|", 1, 1) Then $WordPos[0] = $WordPos[1] + 1
								SendMessageString($Sci, $SCI_REPLACESEL, 0, StringReplace($Replace, "|", "", 1))
								SCI_SetCurrentPos($Sci, $WordPos[0])

								_Scintilla_CallTip_ShowHide_Check($Sci)

							EndIf
						EndIf

					Case Else
						_Scintilla_Trigger_AutoComplete($Sci)




;~ 						#CE
						;		EndIf
				EndSwitch

				;Auto correct operators for exmaple: < > = <>
				If $ScriptEditor_UseAutoFormat_Correction = "true" And SendMessage($Sci, $SCI_GETSTYLEAT, $caretPos - 3, 0) = $SCE_AU3_OPERATOR Then
					Switch Chr($ch)

						Case "&", "=", "+", "*", "<", ">", ":"
							Switch Sci_GetChar($Sci, $caretPos - 3)

								Case "=", "+", "<", ">", "&", "/", "*", "-", "?"
									If Sci_GetChar($Sci, $caretPos - 4) = " " Then
										SendMessage($Sci, $SCI_SETTARGETRANGE, $caretPos - 2, $caretPos - 1)
										SendMessage($Sci, $SCI_REPLACETARGET, StringLen(""), "")
									EndIf

							EndSwitch
					EndSwitch
				EndIf


				If $Bearbeitende_Function_im_skriptbaum_markieren_Modus = "1" Then _Sci_get_Functionname_from_Position($Sci)



			EndIf

		Case $SCN_AUTOCCOMPLETED
			If SendMessage($Sci, $SCI_GETLEXER, 0, 0) = $SCLEX_AU3 Then
				$CompletedWord = SCI_GetCurrentWordEx($Sci, $position)
				Sleep(10)
				$Wordstyle = SendMessage($Sci, $SCI_GETSTYLEAT, $position, 0)
				If Sci_GetChar($Sci, $position) = " " Then $Wordstyle = SendMessage($Sci, $SCI_GETSTYLEAT, $position + 1, 0)

				If $ScriptEditor_UseAutoFormat_Correction = "true" Then

					;Autocomplete brackets..if needet [example: GUICreate(  ]
					$SCI_sCallTipFoundIndices = ArraySearchAll($SCI_sCallTip_Array, $CompletedWord, 0, 0, 1)
					If IsArray($SCI_sCallTipFoundIndices) Then
						If StringInStr($SCI_sCallTip_Array[$SCI_sCallTipFoundIndices[0]], "(") And ($Wordstyle = $SCE_AU3_FUNCTION Or $Wordstyle = $SCE_AU3_UDF) Then
							If Sci_GetChar($Sci, Sci_GetCurrentPos($Sci)) <> "(" Then
								Send("(")
							Else
								Sci_SetCurrentPos($Sci, Sci_GetCurrentPos($Sci) + 1)
							EndIf
						EndIf
					EndIf

					;Autocomplete a space after the keywoard
					;Auto mode
					If $Wordstyle = $SCE_AU3_KEYWORD Then
						Send(" ")
					EndIf

					;Manual mode
					Switch StringLower(StringStripWS($CompletedWord, 3))
						Case "include", "pragma", "onautoitatartregister", "region"
							Send(" ")
					EndSwitch

					;Brace highlighting (thx to jacobslusser)
					_Scintilla_check_Brace_highlighting($Sci)
				EndIf
			EndIf


		Case $SCN_UPDATEUI

			If $Sci <> $Debug_log And $Sci <> $ParameterEditor_SCIEditor And $Sci <> $scintilla_Codeausschnitt And $Sci <> $Makro_Codeausschnitt_GUI_scintilla And $Last_Used_Scintilla_Control <> $Sci And $pelock_obfuscator_GUI_Ausgabe_scintilla <> $Sci And $pelock_obfuscator_GUI_Eingabe_scintilla <> $Sci Then $Last_Used_Scintilla_Control = $Sci

			;Dual Editor Stuff (Verify and ScrollSync)
			If $Scripteditor_EnableDualEditor = "true" Then
				If BitAND($updated, $SC_UPDATE_V_SCROLL) And $Scripteditor_DualEditor_SyncVerticalScrolling = "true" Then
					If Not _ISN_DualEditor_VScrollBothEditors($Sci) Then Return $GUI_RUNDEFMSG
				EndIf

				If BitAND($updated, $SC_UPDATE_H_SCROLL) And $Scripteditor_DualEditor_SyncHorizontalScrolling = "true" Then
					If Not _ISN_DualEditor_HScrollBothEditors($Sci) Then Return $GUI_RUNDEFMSG
				EndIf

				_ISN_DualEditor_VerifyTab($Sci)
			EndIf

			;Nicht beim Debug Editor
			;Current pos to statusbar
			$line = Sci_GetLineFromPos($Sci, Sci_GetCurrentPos($Sci))
			If $Sci <> $Debug_log And $selections = 1 And $Sci <> $ParameterEditor_SCIEditor Then _GUICtrlStatusBar_SetText_ISN($Status_bar, "li=" & $line + 1 & " co=" & (Sci_GetCurrentPos($Sci) - Sci_GetLineStartPos($Sci, $line)) + 1)

			$Automatische_Speicherung_eingabecounter = 0 ;Eingabecounter resetten
			$SCI_Pos_vor_Enter = (Sci_GetCurrentPos($Sci) - Sci_GetLineStartPos($Sci, $line)) + 1
			_Zeige_Detailinfos_zu_aktuellem_Wort(SCI_GetWordFromPos($Sci, SendMessage($Sci, $Sci_GetCurrentPos, 0, 0), 1), $Sci)


			;Brace highlighting (thx to jacobslusser)
			_Scintilla_check_Brace_highlighting($Sci)


			;Update inteli matches to the current visible lines
			If $verwende_intelimark = "true" AND BitAND($updated, $SC_UPDATE_V_SCROLL) AND SendMessage($Sci, $SCI_GETSELECTIONSTART, 0, 0) <> SendMessage($Sci, $SCI_GETSELECTIONEND, 0, 0) Then
				$SCI_SearchRequester_Working = 0 ;Reset
				AdlibRegister("_ISN_Scintilla_ProcessSearchRequest", 10)
				;_ISN_Scintilla_ProcessSearchRequest()
			EndIf


			;Für inteli Matches
			If BitAND($updated, $SC_UPDATE_SELECTION) then
				Local $MatchesRes = _ISN_ScintillaInteliMatches($Sci)
				if $MatchesRes <> 0 then return $MatchesRes
			EndIf
			If BitAND($updated, $SC_UPDATE_SELECTION) Then $Bearbeitende_Function_im_skriptbaum_markieren_Freigegeben = "1"
			If $Bearbeitende_Function_im_skriptbaum_markieren_Modus = "2" And BitAND($updated, $SC_UPDATE_SELECTION) Then _Sci_get_Functionname_from_Position($Sci)


			;Check Text before inserting (also predo the indent stuff)
		Case $SCN_MODIFIED

			If BitAND($modificationType, $SC_MOD_INSERTTEXT) And $Scintilla_LastDeletedText <> "" Then $Scintilla_LastDeletedText = ""
			If BitAND($modificationType, $SC_MOD_BEFOREDELETE) And SendMessage($Sci, $SCI_GETLEXER, 0, 0) = $SCLEX_AU3 And $Scripteditor_AllowBracketpairs = "true" Then
				If (_IsPressed("10", $user32) Or _IsPressed("12", $user32)) Then
					$Scintilla_LastDeletedText = SCI_GetTextRange($Sci, $position, $position + $Length)
				Else
					$Scintilla_LastDeletedText = ""
;~ 					 $Scintilla_LastDeletedText = Sci_GetChar($Sci, $position)
				EndIf

			EndIf

			If BitAND($modificationType, $SC_MOD_INSERTCHECK) And SendMessage($Sci, $SCI_GETLEXER, 0, 0) = $SCLEX_AU3 Then

				Local $tChar = DllStructCreate("char[" & $Length & "]", $Char)
				Local $Inserted_Text = DllStructGetData($tChar, 1)
				$Scintilla_LastInsertedChar2 = $Scintilla_LastInsertedChar ;copy latest to last
				$Scintilla_LastInsertedChar = $Inserted_Text
				Local $current_pos = Sci_GetCurrentPos($Sci)
				Local $current_style = SendMessage($Sci, $SCI_GETSTYLEAT, $current_pos, 0)

				Switch $Inserted_Text

					Case @CRLF ;Enter
						Local $Indent = 0

						$PreviousLine = SCI_GetLine($Sci, Sci_GetLineFromPos($Sci, $current_pos))
						$PreviousLine = StringTrimRight($PreviousLine, (Sci_GetLineStartPos($Sci, Sci_GetLineFromPos($Sci, $current_pos)) + StringLen($PreviousLine)) - $current_pos) ;Trim all Tabs after the coursor
						If $PreviousLine = "" Then Return $GUI_RUNDEFMSG


						;Tab Indent
						If StringInStr($PreviousLine, "then") Or StringInStr($PreviousLine, "while ") Or StringInStr($PreviousLine, "with ") Or StringInStr($PreviousLine, "func ") Or StringInStr($PreviousLine, "for ") Or StringInStr($PreviousLine, "select ") Or StringInStr($PreviousLine, "switch ") Or StringInStr($PreviousLine, "if ") Or StringInStr($PreviousLine, "elseif ") Or StringInStr($PreviousLine, "case") Then $Indent = 1
						If StringStripWS($PreviousLine, 8) = "do" Or StringStripWS($PreviousLine, 8) = "else" Then $Indent = 1
						If StringInStr($PreviousLine, ";") Then $Indent = 0
						If StringInStr($PreviousLine, "return") Then $Indent = 0
						If StringInStr($PreviousLine, "exit") Then $Indent = 0
						If StringInStr($PreviousLine, "exitloop") Then $Indent = 0
						If StringInStr($PreviousLine, "if ") Then
							Local $PreviousLine_tmp = $PreviousLine
							$PreviousLine_tmp = StringTrimLeft($PreviousLine_tmp, StringInStr($PreviousLine_tmp, "then "))
							If StringInStr($PreviousLine_tmp, "(") And StringInStr($PreviousLine_tmp, ")") Then $Indent = 0
						EndIf
						Local $TabsAdd = _ISN_Scintilla_GenerateIndentForNextLine($Sci, $Indent)
						$TabsAdd = @CRLF & $TabsAdd

						;Modify the users input
						SendMessageString($Sci, $SCI_CHANGEINSERTION, StringLen($TabsAdd), $TabsAdd)

						;Correct the indent, if the line was splitted
						If $Scintilla_CorrectIndentAdlib_Indent <> -1 Then
							$Scintilla_CorrectIndentAdlib_Line = Sci_GetLineFromPos($Sci, $current_pos) + 1
							AdlibRegister("_ISN_Scintilla_CorrectIndentAdlib", $KeyboardSpeed)
						EndIf



					Case "$" ;Prevent double typing $ when autocomplete is already visible
						If SendMessage($Sci, $SCI_AUTOCACTIVE, 0, 0) And $current_style <> $SCE_AU3_VARIABLE Then SendMessageString($Sci, $SCI_CHANGEINSERTION, StringLen(""), "")



					Case "(", "[", "{"
						_Scintilla_InsertBracketsAroundSelection($Sci, $Inserted_Text)



						;Allow to overwrite some chars, if autoformat is enabled
					Case ")", "}", "]"
						If $ScriptEditor_UseAutoFormat_Correction = "true" Then
							If $current_style <> $SCE_AU3_STRING And $current_style <> $SCE_AU3_COMMENT And $current_style <> $SCE_AU3_COMMENTBLOCK And $Scintilla_LastInsertedChar2 <> "(" And $Scintilla_LastInsertedChar2 <> "{" And $Scintilla_LastInsertedChar2 <> "[" Then
								_Scintilla_check_Brace_highlighting($Sci, 1) ;Set offset
								If ($current_pos = $bracePos1 Or $current_pos = $bracePos2) And ($bracePos2 <> $INVALID_POSITION And $bracePos1 <> $INVALID_POSITION And Sci_GetChar($Sci, $bracePos1) = $Inserted_Text) Then
									SendMessageString($Sci, $SCI_CHANGEINSERTION, StringLen(""), "")
									Sci_SetCurrentPos($Sci, $current_pos + 1)
									_Scintilla_check_Brace_highlighting($Sci)
								EndIf
							EndIf
						EndIf

					Case '"', "'", ">"
						If _Scintilla_InsertBracketsAroundSelection($Sci, $Inserted_Text) = 1 Then Return $GUI_RUNDEFMSG

						If $ScriptEditor_UseAutoFormat_Correction = "true" Then
							If $current_style = $SCE_AU3_STRING Then
								$lineendpos = Sci_GetLineEndPos($Sci, Sci_GetLineFromPos($Sci, $current_pos))
								If $current_pos + 1 <= $lineendpos And SendMessage($Sci, $SCI_GETSTYLEAT, $current_pos + 1, 0) <> $SCE_AU3_STRING And Sci_GetChar($Sci, $current_pos) = $Inserted_Text Then
									SendMessageString($Sci, $SCI_CHANGEINSERTION, StringLen(""), "")
									Sci_SetCurrentPos($Sci, $current_pos + 1)
									_Scintilla_check_Brace_highlighting($Sci)
								EndIf
							EndIf


						EndIf


					Case "&", "=", "?", "+", "-", "/", "*", "<", "and", "or", "not", ":"
						If $ScriptEditor_UseAutoFormat_Correction = "true" Then
							If Sci_GetChar($Sci, $current_pos - 1) <> " " And $current_style <> $SCE_AU3_COMMENT And $current_style <> $SCE_AU3_COMMENTBLOCK And $current_style <> $SCE_AU3_STRING And $current_pos <> Sci_GetLineStartPos($Sci, Sci_GetLineFromPos($Sci, $current_pos)) And (SendMessage($Sci, $SCI_GETSTYLEAT, $current_pos - 1, 0) <> $SCE_AU3_OPERATOR Or Sci_GetChar($Sci, $current_pos - 1) = ")" Or Sci_GetChar($Sci, $current_pos - 1) = "]") Then
								SendMessageString($Sci, $SCI_CHANGEINSERTION, StringLen(" " & $Inserted_Text), " " & $Inserted_Text)
							EndIf


						EndIf

					Case Else
						If StringLeft($Inserted_Text, 1) = "$" And Sci_GetChar($Sci, $current_pos - 1) = "$" Then ;Correct double $ when pasting text
							Local $NexInsert = StringTrimLeft($Inserted_Text, 1)
							SendMessageString($Sci, $SCI_CHANGEINSERTION, StringLen($NexInsert), $NexInsert)
						EndIf





				EndSwitch
			EndIf


			If (BitAND($modificationType, $SC_MOD_INSERTTEXT) Or BitAND($modificationType, $SC_MOD_DELETETEXT)) And $Parameter_Editor_Laedt_gerade_text = 0 Then

				;Auto COLOURISE over 200 chars
				If $Length > 200 Then
					_ISN_AutoIt_Studio_deactivate_GUI_Messages()
					SendMessage($Sci, $SCI_COLOURISE, 0, -1)
					_ISN_AutoIt_Studio_activate_GUI_Messages()
				EndIf

				If $Sci <> $Debug_log And $Sci <> $ParameterEditor_SCIEditor And $Sci <> $scintilla_Codeausschnitt And $Sci <> $Makro_Codeausschnitt_GUI_scintilla And $Sci <> $ISN_UDF_Manager_GUI_UDFPreview_scintilla And $QuickView_Notes_Scintilla <> $Sci And $pelock_obfuscator_GUI_Ausgabe_scintilla <> $Sci And $pelock_obfuscator_GUI_Eingabe_scintilla <> $Sci Then _Check_tabs_for_changes()
				If $selections > 1 Then Return $GUI_RUNDEFMSG ;Stop here at multi coursor
				If WinActive($ParameterEditor_GUI) And _GUICtrlListView_GetSelectionMark($ParameterEditor_ListView) <> -1 Then
					If $autoit_editor_encoding = "2" Then
						_GUICtrlListView_SetItemText($ParameterEditor_ListView, _GUICtrlListView_GetSelectionMark($ParameterEditor_ListView), _ANSI2UNICODE(StringReplace(Sci_GetText($ParameterEditor_SCIEditor), @CRLF, "")), 1)
					Else
						_GUICtrlListView_SetItemText($ParameterEditor_ListView, _GUICtrlListView_GetSelectionMark($ParameterEditor_ListView), StringReplace(Sci_GetText($ParameterEditor_SCIEditor), @CRLF, ""), 1)
					EndIf
					AdlibRegister("_Parameter_Editor_Aktualisiere_Vorschaulabel", 1)
				EndIf

			EndIf



			;_Scintilla_Refresh_CallTip($Sci)

			If SendMessage($Sci, $SCI_GETLEXER, 0, 0) <> $SCLEX_AU3 Then Return $GUI_RUNDEFMSG
			_Scintilla_check_Brace_highlighting($Sci, -1) ;Reset $lastCaretPos

		Case $SCN_MARGINCLICK
			SendMessage($Sci, $SCI_TOGGLEFOLD, $line_number, 0)
			
			;Update inteli matches when folding code segments to the current visible lines
			If $verwende_intelimark = "true" AND SendMessage($Sci, $SCI_GETSELECTIONSTART, 0, 0) <> SendMessage($Sci, $SCI_GETSELECTIONEND, 0, 0) Then
				$SCI_SearchRequester_Working = 0 ;Reset
				AdlibRegister("_ISN_Scintilla_ProcessSearchRequest", 10)	
			EndIf



		Case $SCN_SAVEPOINTREACHED

		Case $SCN_SAVEPOINTLEFT

	EndSwitch


	;EndIf
	;EndSelect
	$structNMHDR = 0
	$event = 0
	$lParam = 0
EndFunc   ;==>_WM_NOTIFY_EDITOR

;########################### NOTIF´s für den Projektbaum ###########################


Func _Projecttree_event($hWnd, $iMsg, $sPath, $hItem)
	IF BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_TVExplorer) then _Write_ISN_Debug_Console("Projecttree_event hItem:" & $hItem & " hWnd:" & $hWnd, $ISN_Debug_Console_Errorlevel_Info)
	Switch $iMsg
		Case $TV_NOTIFY_BEGINUPDATE
			GUISetCursor(1, 0, $Studiofenster)
		Case $TV_NOTIFY_ENDUPDATE
			GUISetCursor(2, 0, $Studiofenster)
		 Case $TV_NOTIFY_SELCHANGED
;~ 			; Nothing
		Case $TV_NOTIFY_DBLCLK
			Switch $hWnd
				Case GUICtrlGetHandle($hTreeView)
					If _GUICtrlTreeView_GetSelection($hTreeView) = 0 Then Return $GUI_RUNDEFMSG
					Local $FileToOpen = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
					If StringInStr(FileGetAttrib($FileToOpen), "D") Then Return $GUI_RUNDEFMSG ;stop on folders
					If Not FileExists($FileToOpen) Then Return $GUI_RUNDEFMSG
					Try_to_opten_file($FileToOpen)

				Case GUICtrlGetHandle($quick_view_udfexplorer_treeview)
					If $quick_view_udfexplorer_treeview = "" Then Return $GUI_RUNDEFMSG
					If _GUICtrlTreeView_GetSelection($quick_view_udfexplorer_treeview) = 0 Then Return $GUI_RUNDEFMSG
					Local $FileToOpen = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
					If StringInStr(FileGetAttrib($FileToOpen), "D") Then Return $GUI_RUNDEFMSG ;stop on folders
					If Not FileExists($FileToOpen) Then Return $GUI_RUNDEFMSG
					Try_to_opten_file($FileToOpen)



				Case GUICtrlGetHandle($Choose_File_Treeview)
					If _GUICtrlTreeView_GetSelection($Choose_File_Treeview) = 0 Then Return $GUI_RUNDEFMSG
					If StringInStr(_GUICtrlTreeView_GetTree($Choose_File_Treeview, _GUICtrlTreeView_GetSelection($Choose_File_Treeview)), ".", 1, -1) = 0 Then Return $GUI_RUNDEFMSG
					ControlClick($Choose_File_GUI, "", $Choose_File_GUI_OK)

				Case GUICtrlGetHandle($ISN_UDF_Manager_GUI_Treeview)
					If _GUICtrlTreeView_GetSelection($ISN_UDF_Manager_GUI_Treeview) = 0 Then Return $GUI_RUNDEFMSG
					_ISN_UDF_Manager_Inspect_UDF(_GUICtrlTVExplorer_GetSelected($ISN_UDF_Manager_GUI_Treeview))


			EndSwitch


		Case $TV_NOTIFY_RCLICK

			Switch $hWnd

				Case $hWndTreeview, $ISN_UDF_Manager_GUI_hTreeview, $quick_view_udfexplorer_htreeview
					;Prüfe was eigentlich markiert wurde
					Local $SelectedFile = _GUICtrlTVExplorer_GetSelected($hWnd)

					 _SendMessage($Studiofenster, $WM_SETREDRAW, False) ;prevent flickering of the menu bar


					;Check, if there is a file in the clipboard
					If _ISN_TVExplorer_IsAFileInClipboard() Then
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_PasteFileFromClipboard), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_PasteFileFromClipboard, $GUI_ENABLE)
					Else
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_PasteFileFromClipboard), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_PasteFileFromClipboard, $GUI_DISABLE)
					EndIf

					;Check, if that file can be marked as favorite
					If $ShowFavoritesInProjecttree = "true" Then
						If _ISN_Favorites_CheckPathIfFavoriteIsAllowed($SelectedFile) Then
							If Not BitAND(GUICtrlGetState($TreeviewContextMenu_AddToFavorites), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_AddToFavorites, $GUI_ENABLE)
						Else
							If Not BitAND(GUICtrlGetState($TreeviewContextMenu_AddToFavorites), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_AddToFavorites, $GUI_DISABLE)
						EndIf
					EndIf

					;Extra Stuff for au3 Files
					If StringInStr($SelectedFile, "." & $Autoitextension) And Not _IsDir($SelectedFile) Then
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item_Kompilieren), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item_Kompilieren, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item_Jetzt_Kompilieren), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item_Jetzt_Kompilieren, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item_Makro_kompilieren_neu), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item_Makro_kompilieren_neu, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item_Makro_kompilieren_bestehend), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item_Makro_kompilieren_bestehend, $GUI_ENABLE)
					Else
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item_Kompilieren), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item_Kompilieren, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item_Jetzt_Kompilieren), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item_Jetzt_Kompilieren, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item_Makro_kompilieren_neu), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item_Makro_kompilieren_neu, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item_Makro_kompilieren_bestehend), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item_Makro_kompilieren_bestehend, $GUI_DISABLE)
					EndIf

					;Root
					If $Offenes_Projekt = $SelectedFile Or $SelectedFile = _ISN_Variablen_aufloesen($FavoritesSubfolder) Or $SelectedFile = _ISN_Variablen_aufloesen($Standardordner_UDFs) Or $SelectedFile = _ISN_Variablen_aufloesen($PathToAutoItIncludes) Or _WinAPI_PathIsRoot($SelectedFile) Or $SelectedFile = @MyDocumentsDir Or $SelectedFile = @DesktopDir Or $SelectedFile = _ISN_Variablen_aufloesen($Projectfolder) Then
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item1), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item1, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item2), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item2, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item3), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item3, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item4), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item4, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item7), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item7, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item10), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item10, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_CutFileToClipboard), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_CutFileToClipboard, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_CopyFileToClipboard), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_CopyFileToClipboard, $GUI_DISABLE)
					Else
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item1), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item1, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item2), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item2, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item3), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item3, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item4), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item4, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item7), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item7, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item10), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item10, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_CutFileToClipboard), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_CutFileToClipboard, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_CopyFileToClipboard), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_CopyFileToClipboard, $GUI_ENABLE)
					EndIf

					;If selected file is a folder
					If _IsDir($SelectedFile) Then
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Oeffnen_Mit), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Oeffnen_Mit, $GUI_DISABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item1), $GUI_DISABLE) Then GUICtrlSetState($TreeviewContextMenu_Item1, $GUI_DISABLE)
					Else
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Oeffnen_Mit), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Oeffnen_Mit, $GUI_ENABLE)
						If Not BitAND(GUICtrlGetState($TreeviewContextMenu_Item1), $GUI_ENABLE) Then GUICtrlSetState($TreeviewContextMenu_Item1, $GUI_ENABLE)
					EndIf
				    _SendMessage($Studiofenster, $WM_SETREDRAW, True) ;prevent flickering of the menu bar
					Show_KontextMenu($Studiofenster, $TreeviewContextMenu) ;Zeige Contextmenü für den Projektbaum




			EndSwitch



		Case $TV_NOTIFY_VERIFY
			If $hWnd = $Weitere_Dateien_Kompilieren_GUI_hTreeview Then _Weitere_Dateien_Kompilieren_Treeview_Event()

		Case $TV_NOTIFY_DELETINGITEM
			; Nothing
		Case $TV_NOTIFY_DISKMOUNTED
			; Nothing
		Case $TV_NOTIFY_DISKUNMOUNTED
			; Nothing
	EndSwitch
EndFunc   ;==>_Projecttree_event



;Funcs after resizing
Func WM_SIZE($hWnd, $iMsg, $wParam, $lParam)


	if $SystemParametersInfoOldValue <> "" then ;Reset DragFullWindows to the old value
		DllCall("user32.dll", "int", "SystemParametersInfo", "int", 37, "int", $SystemParametersInfoOldValue, "ptr", 0, "int", 2)
	EndIf

	Switch $hWnd

		Case $ISN_UDF_Manager_GUI
			AdlibRegister("_ISN_UDF_Manager_GUIResize", 50)

		Case $ParameterEditor_GUI
			AdlibRegister("_Parametereditor_Fenster_anpassen", 50)

		Case $config_GUI
			AdlibRegister("_ISNSettings_Repos_Configpage_withoutScrollresize", 1)


	EndSwitch


	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_SIZE

;Funcs while resizing
Func WM_SIZING($hWnd, $iMsg, $wParam, $lParam)

	Switch $hWnd

		Case $pelock_obfuscator_GUI
			_PELock_GUI_Resize()


		Case $Codeausschnitt_GUI
			Codeausschnitt_GUI_Resize()


		Case $Makro_Codeausschnitt_GUI
			_Makro_Codeausschnitt_GUI_Resize()


	EndSwitch

	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_SIZING

Func WM_ENTERSIZEMOVE($hWnd, $iMsg, $wParam, $lParam)
	Switch $hWnd

		Case $Studiofenster
		   _ISN_Studiofenster_SetClipchildren("set") ;prevent flickering
		   $WM_ENTERSIZEMOVE_StudiofensterWinPos = _WinGetPos($Studiofenster)

	EndSwitch



	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_ENTERSIZEMOVE


Func WM_EXITSIZEMOVE($hWnd, $iMsg, $wParam, $lParam)


	Switch $hWnd

		Case $Studiofenster
		    _ISN_Studiofenster_SetClipchildren("remove")
			Local $StudiofensterNewPos = _WinGetPos($Studiofenster)
			If IsArray($StudiofensterNewPos) And IsArray($WM_ENTERSIZEMOVE_StudiofensterWinPos) Then
				If ($StudiofensterNewPos[2] <> $WM_ENTERSIZEMOVE_StudiofensterWinPos[2]) Or ($StudiofensterNewPos[3] <> $WM_ENTERSIZEMOVE_StudiofensterWinPos[3]) Then _Resize_with_no_tabrefresh(); AdlibRegister("_Resize_with_no_tabrefresh", 1)
			EndIf


		Case $config_GUI
			AdlibRegister("_ISNSettings_Repos_Configpage_withoutScrollresize", 1)


		Case $ISN_UDF_Manager_GUI
			AdlibRegister("_ISN_UDF_Manager_GUIResize", 50)


		Case $pelock_obfuscator_GUI
			_PELock_GUI_Resize()

		Case $Codeausschnitt_GUI
			Codeausschnitt_GUI_Resize()

		Case $Makro_Codeausschnitt_GUI
			_Makro_Codeausschnitt_GUI_Resize()

		Case $QuickView_GUI
			_QuickView_GUI_Resize()

		Case $console_GUI
			_Resize_Debug_Console()

		Case $ParameterEditor_GUI
			AdlibRegister("_Parametereditor_Fenster_anpassen", 50)

		Case Else
			;Check if it´s an undocked Plugin window
			Local $index_res = _ArraySearch($ISN_Tabs_Additional_Infos_Array, $hWnd, 0, 0, 0, 0, 1, 0)
			If $index_res = -1 Or @error Then Return $GUI_RUNDEFMSG
			If $ISN_Tabs_Additional_Infos_Array[$index_res][1] <> "1" Then Return $GUI_RUNDEFMSG
			Local $plugsize = _WinGetClientSize($SCE_EDITOR[$index_res])
			If Not IsArray($plugsize) Then Return $GUI_RUNDEFMSG
			WinMove($Plugin_Handle[$index_res], "", 0, 0, $plugsize[0], $plugsize[1])
			_SendMessage($Plugin_Handle[$index_res], $WM_ENTERSIZEMOVE)
			_SendMessage($Plugin_Handle[$index_res], $WM_EXITSIZEMOVE)

	EndSwitch

	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_EXITSIZEMOVE





Func WM_RDC($hWnd, $iMsg, $wParam, $lParam)

	#forceref $hWnd, $iMsg, $wParam

	Local $aData = _RDC_GetData($lParam)

	If @error Then
		; Do something because notifications will not come from this thread!
		_Write_ISN_Debug_Console('Error: _RDC_GetData() - ' & @error & ', ' & @extended & ', ' & _RDC_GetDirectory($lParam), $ISN_Debug_Console_Errorlevel_Critical)
		_RDC_Delete($lParam)
		Return $GUI_RUNDEFMSG
	EndIf
	For $i = 1 To $aData[0][0]
		If $RDC_sEvents Then
			$RDC_sEvents &= '|'
		EndIf
		$RDC_sEvents &= $aData[$i][1] & '?' & _RDC_GetDirectory($lParam) & '\' & $aData[$i][0]
	Next
	If $PauseRDCEvents = 0 Then AdlibRegister('_RetrieveDirectoryChanges', 250)
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_RDC


Func _WM_NCACTIVATE($hWnd, $iMsg, $wParam, $lParam)
	Switch $hWnd

		Case $Studiofenster, $ISN_VariablesSelector,$ISN_UDF_Manager_GUI,$QuickView_GUI ;All Guis that contain Child GUIs, or an ACInput Field
			If Not $wParam Then Return 1

	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>_WM_NCACTIVATE

Func _WM_NCACTIVATE_Startup($hWnd, $iMsg, $wParam, $lParam)
	Switch $hWnd

		Case $ISN_StartupLogoGUI
			If Not $wParam Then Return 1

	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc 

Func _WM_WINDOWPOSCHANGING_ausnahmen($hWnd)

	Switch $hWnd

		Case $Studiofenster
			Return False

		Case $QuickView_GUI
			Return False


	EndSwitch


	;Plugins
	If $Offenes_Projekt <> "" Then
		If Not IsArray($SCE_EDITOR) Then Return True
		If Not IsArray($Plugin_Handle) Then Return True
		$SCE_EDITOR_String = _ArrayToString($SCE_EDITOR)
		$Plugin_Handle_String = _ArrayToString($Plugin_Handle)
		If StringInStr($SCE_EDITOR_String, $hWnd) Then Return False
		If StringInStr($Plugin_Handle_String, $hWnd) Then Return False
	EndIf


	Return True
EndFunc   ;==>_WM_WINDOWPOSCHANGING_ausnahmen

Func WM_WINDOWPOSCHANGING($hWnd, $msg, $wParam, $lParam)
	If BitAND(WinGetState($Studiofenster, ""), 16) Then Return ;Nicht wenn Minimiert
	$size_new_resize = _WinGetClientSize($Studiofenster, "")
	If Not IsArray($size_new_resize) Then Return
	If $size_new_resize[0] < 0 Then Return
	If $size_new_resize[1] < 0 Then Return
	If $size_new_resize[0] = 0 Then Return ;Fenster ist Minimiert
	If $size_new_resize[1] = 0 Then Return ;Fenster ist Minimiert


;~ If BitAND(WinGetState($Studiofenster, ""), 8) Then

;~ 	if not _Is_GUI_in_Studiofenster($hWnd) Then

;~ ConsoleWrite(WinGetTitle($hWnd)&@crlf)
;~    Local $a_WinGetPos = _WinGetPos($hWnd)
;~     If @error  Or $a_WinGetPos[0] < -30000 Then Return $GUI_RUNDEFMSG
;~     Local $tWindowPos = DllStructCreate($tagWINDOWPOS, $lParam)
;~     DllStructSetData($tWindowPos, 'X', $a_WinGetPos[0])
;~     DllStructSetData($tWindowPos, 'Y', $a_WinGetPos[1])
;~ 		return
;~ Endif
;~ Endif


	If _WM_WINDOWPOSCHANGING_ausnahmen($hWnd) Then
		Local $stWinPos = DllStructCreate("uint;uint;int;int;int;int;uint", $lParam)

		;Das selbe auch für das QuickView Fenster
		If IsDeclared("QuickView_Dummy_Control") And IsDeclared("Studiofenster") And IsDeclared("QuickView_GUI") Then
			$QuickView_Dummy_Control_Posarray = _ControlGetPos($Studiofenster, "", $QuickView_Dummy_Control)
			If IsArray($QuickView_Dummy_Control_Posarray) And $hWnd = $QuickView_GUI Then
				DllStructSetData($stWinPos, 3, $QuickView_Dummy_Control_Posarray[0])
				DllStructSetData($stWinPos, 4, $QuickView_Dummy_Control_Posarray[1])
			EndIf
		EndIf

		Local $iLeft = DllStructGetData($stWinPos, 3)
		Local $iTop = DllStructGetData($stWinPos, 4)
		Local $iWidth = DllStructGetData($stWinPos, 5)
		Local $iHeight = DllStructGetData($stWinPos, 6)

		If $iLeft < $iX_Min - ($iWidth - 160) Then DllStructSetData($stWinPos, 3, $iX_Min - ($iWidth - 160))
		If $iTop < $iY_Min Then DllStructSetData($stWinPos, 4, $iY_Min)
		If $iLeft > $iX_Max - 50 Then DllStructSetData($stWinPos, 3, $iX_Max - 50)
		If $iTop > $iY_Max - 50 Then DllStructSetData($stWinPos, 4, $iY_Max - 50)
	EndIf

	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_WINDOWPOSCHANGING

Func WM_WINDOWPOSCHANGING_STARTUP($hWnd, $msg, $wParam, $lParam)
	Local $stWinPos = DllStructCreate("uint;uint;int;int;int;int;uint", $lParam)
	Local $iLeft = DllStructGetData($stWinPos, 3)
	Local $iTop = DllStructGetData($stWinPos, 4)
	Local $iWidth = DllStructGetData($stWinPos, 5)
	Local $iHeight = DllStructGetData($stWinPos, 6)

	If $iLeft < $iX_Min - ($iWidth - 160) Then DllStructSetData($stWinPos, 3, $iX_Min - ($iWidth - 160))
	If $iTop < $iY_Min Then DllStructSetData($stWinPos, 4, $iY_Min)
	If $iLeft > $iX_Max - 50 Then DllStructSetData($stWinPos, 3, $iX_Max - 50)
	If $iTop > $iY_Max - 50 Then DllStructSetData($stWinPos, 4, $iY_Max - 50)

	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_WINDOWPOSCHANGING_STARTUP


; Handle WM_CONTEXTMENU messages
Func WM_CONTEXTMENU_EDITOR($hWnd, $iMsg, $iwParam, $ilParam)

	Local $tmenu
	Local $current_Scintilla_Window = _WinAPI_GetFocus()
	If _WinAPI_GetClassName($current_Scintilla_Window) <> "Scintilla" Then Return
	If Not _hit_win($current_Scintilla_Window) Then Return ;Only show the context menu when we are in the window with the focus
	;Check if we need to show the full context menu, or the lite (default) one
	_ArraySearch($SCE_EDITOR, $current_Scintilla_Window)
	If @error Then

		;Check if the "undo" button should be enabled
		If SendMessage($current_Scintilla_Window, $SCI_CANUNDO, 0, 0) = 1 Then
			GUICtrlSetState($ScripteditorDefaultContextMenu_undo, $GUI_ENABLE)
		Else
			GUICtrlSetState($ScripteditorDefaultContextMenu_undo, $GUI_DISABLE)
		EndIf

		;Check if the "redo" button should be enabled
		If SendMessage($current_Scintilla_Window, $SCI_CANREDO, 0, 0) = 1 Then
			GUICtrlSetState($ScripteditorDefaultContextMenu_redo, $GUI_ENABLE)
		Else
			GUICtrlSetState($ScripteditorDefaultContextMenu_redo, $GUI_DISABLE)
		EndIf

		Sleep(10)
		Show_KontextMenu($Studiofenster, $ScripteditorDefaultContextMenu)
		Return
	EndIf

	;Check if the menu "open file" should be enabled. (For example for includes)
	$str = Sci_GetLine($current_Scintilla_Window, Sci_GetCurrentLine($current_Scintilla_Window) - 1)
	If StringInStr($str, "#include") And StringInStr($str, ".") Then
		GUICtrlSetState($SCI_EDITOR_CONTEXT_oeffneInclude, $GUI_ENABLE)
	Else
		GUICtrlSetState($SCI_EDITOR_CONTEXT_oeffneInclude, $GUI_DISABLE)
	EndIf

	;Check for file paths
	$array = _StringBetween($str, '"', '"', -1)
	For $u = 0 To UBound($array) - 1
		If FileExists($array[$u]) Then GUICtrlSetState($SCI_EDITOR_CONTEXT_oeffneInclude, $GUI_ENABLE)
	Next

	$array = _StringBetween($str, "'", "'", -1)
	For $u = 0 To UBound($array) - 1
		If FileExists($array[$u]) Then GUICtrlSetState($SCI_EDITOR_CONTEXT_oeffneInclude, $GUI_ENABLE)
	Next


	;Check if the "undo" button should be enabled
	If SendMessage($current_Scintilla_Window, $SCI_CANUNDO, 0, 0) = 1 Then
		GUICtrlSetState($SCI_EDITOR_CONTEXT_rueckgaengig, $GUI_ENABLE)
	Else
		GUICtrlSetState($SCI_EDITOR_CONTEXT_rueckgaengig, $GUI_DISABLE)
	EndIf

	;Check if the "redo" button should be enabled
	If SendMessage($current_Scintilla_Window, $SCI_CANREDO, 0, 0) = 1 Then
		GUICtrlSetState($SCI_EDITOR_CONTEXT_wiederholen, $GUI_ENABLE)
	Else
		GUICtrlSetState($SCI_EDITOR_CONTEXT_wiederholen, $GUI_DISABLE)
	EndIf


	Sleep(10)
	Show_KontextMenu($Studiofenster, $ScripteditorContextMenu)
	Return True
EndFunc   ;==>WM_CONTEXTMENU_EDITOR

Func WM_GETMINMAXINFO($hWnd, $msg, $wParam, $lParam)
	$tagMaxinfo = DllStructCreate("int;int;int;int;int;int;int;int;int;int", $lParam)

	Switch $hWnd

;~ 		Case $Config_GUI
;~ 			DllStructSetData($tagMaxinfo, 7, $Programmeinstellungen_width)
;~ 			DllStructSetData($tagMaxinfo, 8, $Programmeinstellungen_height)

		Case $ISN_StartupLogoGUI
			return 0
			
		Case $NEW_PROJECT_GUI
			DllStructSetData($tagMaxinfo, 7, $Neues_Projekt_width)
			DllStructSetData($tagMaxinfo, 8, $Neues_Projekt_height)

		Case $projectmanager
			DllStructSetData($tagMaxinfo, 7, $Projektverwaltung_width)
			DllStructSetData($tagMaxinfo, 8, $Projektverwaltung_height)

		Case $Projekteinstellungen_GUI
			DllStructSetData($tagMaxinfo, 7, $Projekteinstellungen_width)
			DllStructSetData($tagMaxinfo, 8, $Projekteinstellungen_height)

		Case $ruleseditor
			DllStructSetData($tagMaxinfo, 7, $Makros_width)
			DllStructSetData($tagMaxinfo, 8, $Makros_height)

		Case $skriuptbaum_FilterGUI
			DllStructSetData($tagMaxinfo, 7, $Skriptbaumfilter_width)
			DllStructSetData($tagMaxinfo, 8, $Skriptbaumfilter_height)

		Case $parameter_GUI
			DllStructSetData($tagMaxinfo, 7, $Startparameter_width)
			DllStructSetData($tagMaxinfo, 8, $Startparameter_height)

		Case $Makro_auswaehlen_GUI
			DllStructSetData($tagMaxinfo, 7, $makro_waehlen_width)
			DllStructSetData($tagMaxinfo, 8, $makro_waehlen_height)

		Case $newrule_GUI
			DllStructSetData($tagMaxinfo, 7, $makro_bearbeiten_width)
			DllStructSetData($tagMaxinfo, 8, $makro_bearbeiten_height)

		Case $aenderungs_manager_GUI
			DllStructSetData($tagMaxinfo, 7, $aenderungsprotokolle_width)
			DllStructSetData($tagMaxinfo, 8, $aenderungsprotokolle_height)

		Case $neuer_changelog_eintrag_GUI
			DllStructSetData($tagMaxinfo, 7, $aenderungsprotokolle_neuer_eintrag_width)
			DllStructSetData($tagMaxinfo, 8, $aenderungsprotokolle_neuer_eintrag_height)

		Case $changelog_generieren_GUI
			DllStructSetData($tagMaxinfo, 7, $aenderungsprotokolle_bericht_width)
			DllStructSetData($tagMaxinfo, 8, $aenderungsprotokolle_bericht_height)


		Case $ParameterEditor_GUI
			DllStructSetData($tagMaxinfo, 7, $parameter_editor_width)
			DllStructSetData($tagMaxinfo, 8, $parameter_editor_height)

		Case $Funclist_GUI
			DllStructSetData($tagMaxinfo, 7, $Funclist_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $Funclist_GUI_height)

		Case $ISNSTudio_debug
			DllStructSetData($tagMaxinfo, 7, $ISNSTudio_debug_width)
			DllStructSetData($tagMaxinfo, 8, $ISNSTudio_debug_height)

		Case $pelock_obfuscator_GUI
			DllStructSetData($tagMaxinfo, 7, $pelock_obfuscator_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $pelock_obfuscator_GUI_height)

		Case $ExecuteCommandRuleConfig_GUI
			DllStructSetData($tagMaxinfo, 7, $ExecuteCommandRuleConfig_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $ExecuteCommandRuleConfig_GUI_height)

		Case $TemplateNEU
			DllStructSetData($tagMaxinfo, 7, $TemplateNEU_width)
			DllStructSetData($tagMaxinfo, 8, $TemplateNEU_height)

		Case $ToDo_Liste_neuer_eintrag_GUI
			DllStructSetData($tagMaxinfo, 7, $ToDo_Liste_neuer_eintrag_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $ToDo_Liste_neuer_eintrag_GUI_height)

		Case $ToDoList_Manager
			DllStructSetData($tagMaxinfo, 7, $ToDoList_Manager_width)
			DllStructSetData($tagMaxinfo, 8, $ToDoList_Manager_height)

		Case $macro_runscriptGUI
			DllStructSetData($tagMaxinfo, 7, $macro_runscriptGUI_width)
			DllStructSetData($tagMaxinfo, 8, $macro_runscriptGUI_height)

		Case $rulecompileconfig_gui
			DllStructSetData($tagMaxinfo, 7, $rulecompileconfig_gui_width)
			DllStructSetData($tagMaxinfo, 8, $rulecompileconfig_gui_height)

		Case $rule_fileoperation_configgui
			DllStructSetData($tagMaxinfo, 7, $rule_fileoperation_configgui_width)
			DllStructSetData($tagMaxinfo, 8, $rule_fileoperation_configgui_height)

		Case $msgboxcreator_rule
			DllStructSetData($tagMaxinfo, 7, $msgboxcreator_rule_width)
			DllStructSetData($tagMaxinfo, 8, $msgboxcreator_rule_height)

		Case $runfile_config
			DllStructSetData($tagMaxinfo, 7, $runfile_config_width)
			DllStructSetData($tagMaxinfo, 8, $runfile_config_height)

		Case $parameter_GUI_rule
			DllStructSetData($tagMaxinfo, 7, $parameter_GUI_rule_width)
			DllStructSetData($tagMaxinfo, 8, $parameter_GUI_rule_height)

		Case $addlog_GUI
			DllStructSetData($tagMaxinfo, 7, $addlog_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $addlog_GUI_height)

		Case $stausbar_Set_GUI
			DllStructSetData($tagMaxinfo, 7, $stausbar_Set_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $stausbar_Set_GUI_height)

		Case $Weitere_Dateien_Kompilieren_GUI
			DllStructSetData($tagMaxinfo, 7, $Weitere_Dateien_Kompilieren_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $Weitere_Dateien_Kompilieren_GUI_height)

		Case $fFind1
			DllStructSetData($tagMaxinfo, 7, $fFind1_width)
			DllStructSetData($tagMaxinfo, 8, $fFind1_height)

		Case $ISN_APIGeneratorGUI
			DllStructSetData($tagMaxinfo, 7, $ISN_APIGeneratorGUI_width)
			DllStructSetData($tagMaxinfo, 8, $ISN_APIGeneratorGUI_height)

		Case $ISN_UDF_Manager_GUI
			DllStructSetData($tagMaxinfo, 7, $ISN_UDF_Manager_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $ISN_UDF_Manager_GUI_height)

		Case $ISN_VariablesSelector
			DllStructSetData($tagMaxinfo, 7, $ISN_VariablesSelector_GUI_width)
			DllStructSetData($tagMaxinfo, 8, $ISN_VariablesSelector_GUI_height)

		Case Else
			DllStructSetData($tagMaxinfo, 7, $GUIMINWID) ; min X
			DllStructSetData($tagMaxinfo, 8, $GUIMINHT) ; min Y

	EndSwitch

	_GUICtrlStatusBar_Resize($Status_bar)
	Return 0
EndFunc   ;==>WM_GETMINMAXINFO




Func WM_MOUSEACTIVATE($hWndGUI, $MsgID, $wParam, $lParam)
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) > 0 Then
		If _GUICtrlTab_GetCurFocus($htab) = -1 Then Return
		If $Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)] = -1 Then Return
		If $hWndGUI = $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)] Then Return $MA_NOACTIVATEANDEAT ;Stop activating the Plugin Container Window
	EndIf
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_MOUSEACTIVATE



Func WM_NCHITTEST($hWnd, $iMsg, $iwParam, $ilParam)
	If IsDeclared("ISN_StartupLogoGUI") Then
		If $hWnd = $ISN_StartupLogoGUI And ($iMsg = $WM_NCHITTEST) Then Return $HTCAPTION
	EndIf
EndFunc   ;==>WM_NCHITTEST

Func WM_NCCALCSIZE($hWnd, $iMsg, $iwParam, $ilParam)
	If IsDeclared("ISN_StartupLogoGUI") Then
		If $hWnd = $ISN_StartupLogoGUI And $iwParam Then Return 0
	EndIf
	Return $GUI_RUNDEFMSG
EndFunc   

Func WM_DROPFILES_FUNC($hWnd, $MsgID, $wParam, $lParam)
	Local $nSize, $pFileName
	Local $nAmt = DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $wParam, "int", 0xFFFFFFFF, "ptr", 0, "int", 255)
	For $i = 0 To $nAmt[0] - 1
		$nSize = DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $wParam, "int", $i, "ptr", 0, "int", 0)
		$nSize = $nSize[0] + 1
		$pFileName = DllStructCreate("char[" & $nSize & "]")
		DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $wParam, "int", $i, "ptr", DllStructGetPtr($pFileName), "int", $nSize)
		ReDim $gaDropFiles[$i + 1]
		$gaDropFiles[$i] = DllStructGetData($pFileName, 1)
		$pFileName = 0
	Next
	_Drag_and_drop_import_file($nAmt[0], $gaDropFiles)
EndFunc   ;==>WM_DROPFILES_FUNC




;~    ;Also check Context menu hits of undocked tabs
;~    for $cnt = 0 to ubound($ISN_Tabs_Additional_Infos_Array)-1
;~ 	  if $ISN_Tabs_Additional_Infos_Array[$cnt][1] <> "1" then ContinueLoop
;~ 	  if $nID = $ISN_Tabs_Additional_Infos_Array[$cnt][2] Then
;~ 		 msgbox(0,"j","j",0,$Studiofenster)
;~ 	  Endif
;~    Next



Func _WM_SYSCOMMAND($hWnd, $msg, $wParam, $lParam)
	$nID = BitAND($wParam, 0xFFF0)


	If $hWnd <> $Studiofenster then
		Switch $nID
			Case $SC_SIZE ;Disable realtime redraw of all resizing windows
				DllCall("user32.dll", "int", "SystemParametersInfo", "int", 37, "int", 0, "ptr", 0, "int", 2)


		EndSwitch
	Endif

	If $hWnd = $Studiofenster then
		Switch $nID
			Case $SC_RESTORE, $SC_MAXIMIZE, $SC_SIZE, $SC_MOVE ;The main gui is about to restore/maximize/resize
				If not BitAND(WinGetState($Studiofenster, ""), 16) Then
					$size_before_resize = _WinGetClientSize($StudioFenster, "") ;Save GUI size before resize actions
				EndIf

		EndSwitch
	Endif

	;check Context menu hits of undocked tabs
	$nID = BitAND($wParam, 0x0000FFFF)
	For $cnt = 0 To UBound($ISN_Tabs_Additional_Infos_Array) - 1
		If $ISN_Tabs_Additional_Infos_Array[$cnt][1] <> "1" Then ContinueLoop
		If $nID = $ISN_Tabs_Additional_Infos_Array[$cnt][2] Then
			_ISN_ReDock_Tab($cnt)
		EndIf
	Next
EndFunc   ;==>_WM_SYSCOMMAND

Func WM_DRAWCLIPBOARD($hWnd, $iMsg, $iwParam, $ilParam)
	_ISN_ClipBoardEvent()
 EndFunc   ;==>WM_DRAWCLIPBOARD


Func _AcInputUDF_CallbackFunc($hWnd, $iMsg, $iwParam, $ilParam)

	Switch $hWnd

		;Check Autocomplete controls (for example the search input in the scripttree)
		Case _AcInputUDF_IsControlRegistered($hWnd)
			Local $iCurrIndex = _GUICtrlListBox_GetCurSel($AcInputUDF_ACListControlHandle)
			Switch $iMsg
;~ 			  Case $WM_CHAR
;~ 				  ConsoleWrite('WM_CHAR: ' & $iwParam & @LF)
				Case $WM_KEYDOWN

					;UP KEY
					If $iwParam = 38 Then
						_AcInputUDF_SelectPrevItemInList()
						Return -1 ;Stop here. Prevent from sending the key to the control
					EndIf

					;DOWN KEY
					If $iwParam = 40 Then
						_AcInputUDF_SelectNextItemInList()
						Return -1 ;Stop here. Prevent from sending the key to the control
					EndIf

					 ;Input Checker for Autocomplete
					_AcInputUDF_CheckInput(_WinAPI_GetDlgCtrlID($hWnd))

				Case $WM_KEYUP


					;ENTER KEY
					If $iwParam = 13 Then

						Switch _WinAPI_GetDlgCtrlID($hWnd)

							Case $ISN_UDF_Manager_FileSearch_Input
								_ISN_UDFManager_AcInputSelectItem()

							Case $quick_view_udfexplorer_searchbar
								_ISN_QuickView_UDFExplorer_AcInputSelectItem()

							Case $Projecttree_Searchbar
								_ISN_ProjecttreeSearchbar_AcInputSelectItem()

							Case $ISN_VariablesSelector_Searchbar
								_ISN_VariablesSelector_Searchbar_AcInputSelectItem()

						EndSwitch
					EndIf

			EndSwitch

	EndSwitch

	Return $GUI_RUNDEFMSG
EndFunc   ;==>_AcInputUDF_CallbackFunc



Func _WM_NCLBUTTONDBLCLK($hWnd, $iMsg, $wParam, $lParam)
	Switch $hWnd
		Case $Studiofenster
			AdlibRegister("_Resize_with_no_tabrefresh_and_noRedraw", 250)
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>_WM_NCLBUTTONDBLCLK

Func _WM_THEMECHANGED($hWnd, $Msg, $wParam, $lParam)
    Switch $Msg
        Case $WM_THEMECHANGED
            _Rezize(0, 1)
            Return $GUI_RUNDEFMSG
    EndSwitch
EndFunc

Func _ISN_AutoIt_Studio_activate_GUI_Messages()
	GUIRegisterMsg($WM_NOTIFY, '_WM_NOTIFY')
	GUIRegisterMsg($WM_COMMAND, "_InputCheck")
	GUIRegisterMsg($WM_SYSCOMMAND, "_WM_SYSCOMMAND")
	GUIRegisterMsg($WM_DROPFILES, "WM_DROPFILES_FUNC")
	GUIRegisterMsg($WM_GETMINMAXINFO, "WM_GETMINMAXINFO")
	GUIRegisterMsg($WM_WINDOWPOSCHANGING, "WM_WINDOWPOSCHANGING")
	GUIRegisterMsg($WM_NCLBUTTONDBLCLK, "_WM_NCLBUTTONDBLCLK") ;Double click on title bar
	GUIRegisterMsg($WM_SIZE, "WM_SIZE")
	GUIRegisterMsg($WM_SIZING, "WM_SIZING")
	GUIRegisterMsg($WM_ENTERSIZEMOVE, "WM_ENTERSIZEMOVE")
	GUIRegisterMsg($WM_EXITSIZEMOVE, "WM_EXITSIZEMOVE")
	GUIRegisterMsg($WM_NCACTIVATE, "_WM_NCACTIVATE")
	GUIRegisterMsg($WM_RDC, 'WM_RDC')
	GUIRegisterMsg($WM_DRAWCLIPBOARD, "WM_DRAWCLIPBOARD")
;~ 	GUIRegisterMsg($WM_MOUSEACTIVATE, 'WM_MOUSEACTIVATE')
	;GUIRegisterMsg($WM_THEMECHANGED, '_WM_THEMECHANGED')
	Return True
EndFunc   ;==>_ISN_AutoIt_Studio_activate_GUI_Messages

Func _ISN_AutoIt_Studio_deactivate_GUI_Messages()
	GUIRegisterMsg($WM_NOTIFY, '')
	GUIRegisterMsg($WM_COMMAND, "")
	GUIRegisterMsg($WM_SYSCOMMAND, "")
	GUIRegisterMsg($WM_DROPFILES, "")
;~ 	GUIRegisterMsg($WM_GETMINMAXINFO, "")
;~ 	GUIRegisterMsg($WM_WINDOWPOSCHANGING, "")
;~ 	GUIRegisterMsg($WM_NCLBUTTONDBLCLK, "")
;~ 	GUIRegisterMsg($WM_SIZE, "")
;~ 	GUIRegisterMsg($WM_SIZING, "")
;~ 	GUIRegisterMsg($WM_ENTERSIZEMOVE, "")
;~  GUIRegisterMsg($WM_EXITSIZEMOVE, "")
;~ 	GUIRegisterMsg($WM_NCACTIVATE, "")
;~ 	GUIRegisterMsg($WM_RDC, '')
;~ 	GUIRegisterMsg($WM_DRAWCLIPBOARD, "")
;~ 	GUIRegisterMsg($WM_MOUSEACTIVATE, 'WM_MOUSEACTIVATE')
;~ 	GUIRegisterMsg($WM_THEMECHANGED, '')
	Return True
EndFunc   ;==>_ISN_AutoIt_Studio_deactivate_GUI_Messages


